/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.hadoop;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Plugin;
import hudson.Proc;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.hadoop.HadoopPage;
import hudson.remoting.Channel;
import hudson.remoting.Which;
import hudson.slaves.Channels;
import hudson.util.ArgumentListBuilder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class PluginImpl
extends Plugin {
    Channel channel;
    public static final int JOB_TRACKER_PORT_NUMBER = 50040;

    public void start() throws Exception {
        Hudson.getInstance().getActions().add(new HadoopPage());
    }

    public String getHdfsUrl() throws MalformedURLException {
        String rootUrl = Hudson.getInstance().getRootUrl();
        if (rootUrl == null) {
            return null;
        }
        URL url = new URL(rootUrl);
        return "hdfs://" + url.getHost() + ":9000/";
    }

    public String getJobTrackerAddress() throws MalformedURLException {
        String rootUrl = Hudson.getInstance().getRootUrl();
        if (rootUrl == null) {
            return null;
        }
        URL url = new URL(rootUrl);
        return url.getHost() + ":" + 50040;
    }

    static Channel createHadoopVM(File rootDir, TaskListener listener) throws IOException, InterruptedException {
        rootDir = new File(rootDir, "hadoop");
        File distDir = new File(rootDir, "dist");
        File logDir = new File(rootDir, "logs");
        if (PluginImpl.shouldInstallBinary(distDir)) {
            listener.getLogger().println("Installing Hadoop binaries");
            if (distDir.exists()) {
                new FilePath(distDir).deleteContents();
            }
            new FilePath(distDir).untarFrom(PluginImpl.class.getResourceAsStream("hadoop.tar.gz"), FilePath.TarCompression.GZIP);
            FileUtils.writeStringToFile((File)new File(distDir, "MD5"), (String)PluginImpl.getHadoopTarGzMd5());
        }
        logDir.mkdirs();
        ServerSocket serverSocket = new ServerSocket();
        serverSocket.bind(null);
        serverSocket.setSoTimeout(10000);
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new File(System.getProperty("java.home"), "bin/java"));
        args.add("-Dhadoop.log.dir=" + logDir);
        args.add("-jar");
        args.add(Which.jarFile(Channel.class));
        StringBuilder classpath = new StringBuilder();
        for (String mask : new String[]{"hadoop-*-core.jar", "lib/**/*.jar"}) {
            for (FilePath jar : new FilePath(distDir).list(mask)) {
                if (classpath.length() > 0) {
                    classpath.append(File.pathSeparatorChar);
                }
                classpath.append(jar.getRemote());
            }
        }
        args.add("-cp").add((Object)classpath);
        args.add(new String[]{"-connectTo", "localhost:" + serverSocket.getLocalPort()});
        listener.getLogger().println("Starting Hadoop");
        Proc p = new Launcher.LocalLauncher(listener).launch(args.toCommandArray(), new String[0], (OutputStream)listener.getLogger(), null);
        Socket s = serverSocket.accept();
        serverSocket.close();
        return Channels.forProcess((String)"Channel to Hadoop", (ExecutorService)Computer.threadPoolForRemoting, (InputStream)new BufferedInputStream(s.getInputStream()), (OutputStream)new BufferedOutputStream(s.getOutputStream()), (Proc)p);
    }

    private static boolean shouldInstallBinary(File distDir) throws IOException {
        String md5;
        if (!distDir.exists()) {
            return true;
        }
        File checksum = new File(distDir, "MD5");
        return !checksum.exists() || !(md5 = FileUtils.readFileToString((File)checksum)).equals(PluginImpl.getHadoopTarGzMd5());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHadoopTarGzMd5() throws IOException {
        InputStream in = PluginImpl.class.getResourceAsStream("hadoop.tar.gz.MD5");
        try {
            String string = IOUtils.toString((InputStream)in);
            return string;
        }
        finally {
            in.close();
        }
    }

    public void stop() throws Exception {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    public static PluginImpl get() {
        return (PluginImpl)Hudson.getInstance().getPlugin(PluginImpl.class);
    }
}

