/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.hadoop;

import hudson.plugins.hadoop.SlaveTask;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskTracker;

class TaskTrackerStartTask
extends SlaveTask {
    private final String jobTrackerAddress;
    private static final long serialVersionUID = 1L;

    TaskTrackerStartTask(String hdfsUrl, String rootPath, String address, String jobTrackerAddress) {
        super(hdfsUrl, rootPath, address);
        this.jobTrackerAddress = jobTrackerAddress;
    }

    public Void call() throws IOException {
        System.out.println("Starting data node");
        JobConf conf = new JobConf();
        conf.set("fs.default.name", this.hdfsUrl);
        conf.set("mapred.job.tracker", this.jobTrackerAddress);
        conf.set("mapred.task.tracker.http.address", "0.0.0.0:0");
        conf.set("mapred.task.tracker.report.address", "0.0.0.0:0");
        conf.set("mapred.local.dir", new File(new File(this.rootPath), "hadoop/task-tracker").getAbsolutePath());
        conf.set("slave.host.name", this.slaveHostName);
        new Thread((Runnable)new TaskTracker(conf)).start();
        return null;
    }
}

