/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.hadoop;

import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.plugins.hadoop.PluginImpl;
import hudson.plugins.hadoop.SlaveStartTask;
import hudson.remoting.Callable;
import hudson.slaves.ComputerListener;
import java.io.IOException;
import java.util.logging.Logger;

public class ComputerListenerImpl
extends ComputerListener {
    private static final Logger LOGGER = Logger.getLogger(ComputerListenerImpl.class.getName());

    public void onOnline(Computer c, TaskListener listener) {
        try {
            PluginImpl p = PluginImpl.get();
            String hdfsUrl = p.getHdfsUrl();
            if (hdfsUrl != null) {
                String address = c.getHostName();
                if (address == null) {
                    listener.getLogger().println("Unable to determine the hostname/IP address of this system. Skipping Hadoop deployment");
                } else {
                    c.getChannel().call((Callable)new SlaveStartTask(c, listener, hdfsUrl, address));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to start Hadoop"));
        }
        catch (InterruptedException e) {
            e.printStackTrace(listener.error("Failed to start Hadoop"));
        }
    }
}

