/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.hadoop;

import hudson.FilePath;
import hudson.Plugin;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.hadoop.HadoopPage;
import hudson.remoting.Channel;
import hudson.slaves.Channels;
import hudson.util.ClasspathBuilder;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;

public class PluginImpl
extends Plugin {
    Channel channel;
    public static final int JOB_TRACKER_PORT_NUMBER = 50040;

    public void start() throws Exception {
        Hudson.getInstance().getActions().add(new HadoopPage());
    }

    public String getHdfsUrl() throws MalformedURLException {
        InetSocketAddress a = this.getHdfsAddress();
        if (a == null) {
            return null;
        }
        return "hdfs://" + a.getHostName() + ":" + a.getPort() + "/";
    }

    public InetSocketAddress getHdfsAddress() throws MalformedURLException {
        String rootUrl = Hudson.getInstance().getRootUrl();
        if (rootUrl == null) {
            return null;
        }
        URL url = new URL(rootUrl);
        return new InetSocketAddress(url.getHost(), 9000);
    }

    public DFSClient createDFSClient() throws IOException {
        return new DFSClient(this.getHdfsAddress(), new Configuration(false));
    }

    public String getJobTrackerAddress() throws MalformedURLException {
        String rootUrl = Hudson.getInstance().getRootUrl();
        if (rootUrl == null) {
            return null;
        }
        URL url = new URL(rootUrl);
        return url.getHost() + ":" + 50040;
    }

    static Channel createHadoopVM(File rootDir, TaskListener listener) throws IOException, InterruptedException {
        rootDir = new File(rootDir, "hadoop");
        FilePath distDir = new FilePath(new File(rootDir, "dist"));
        distDir.installIfNecessaryFrom(PluginImpl.class.getResource("hadoop.tar.gz"), listener, "Hadoop");
        File logDir = new File(rootDir, "logs");
        logDir.mkdirs();
        return Channels.newJVM((String)"Hadoop", (TaskListener)listener, null, (ClasspathBuilder)new ClasspathBuilder().addAll(distDir, "hadoop-*-core.jar").addAll(distDir, "lib/**/*.jar").add(distDir.child("conf")), Collections.singletonMap("hadoop.log.dir", logDir.getAbsolutePath()));
    }

    public void stop() throws Exception {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    public static PluginImpl get() {
        return (PluginImpl)Hudson.getInstance().getPlugin(PluginImpl.class);
    }
}

