/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.hadoop;

import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.plugins.hadoop.JobTrackerStartTask;
import hudson.plugins.hadoop.NameNodeStartTask;
import hudson.plugins.hadoop.PluginImpl;
import hudson.remoting.Callable;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ItemListenerImpl
extends ItemListener {
    private static final Logger LOGGER = Logger.getLogger(ItemListenerImpl.class.getName());

    public void onLoaded() {
        try {
            PluginImpl p = PluginImpl.get();
            String hdfsUrl = p.getHdfsUrl();
            if (hdfsUrl != null) {
                StreamTaskListener listener = new StreamTaskListener(System.out);
                File root = Hudson.getInstance().getRootDir();
                p.channel = PluginImpl.createHadoopVM(root, (TaskListener)listener);
                p.channel.call((Callable)new NameNodeStartTask(root, hdfsUrl));
                p.channel.callAsync((Callable)new JobTrackerStartTask(root, hdfsUrl, p.getJobTrackerAddress()));
            } else {
                LOGGER.info("Skipping Hadoop initialization because we don't know the root URL.");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to start Hadoop on master", e);
        }
    }

    public static PluginImpl get() {
        return (PluginImpl)Hudson.getInstance().getPlugin(PluginImpl.class);
    }
}

