/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.hadoop;

import hudson.plugins.hadoop.SlaveTask;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.datanode.DataNode;

class DataNodeStartTask
extends SlaveTask {
    private static final long serialVersionUID = 1L;

    DataNodeStartTask(String hdfsUrl, String rootPath, String address) {
        super(hdfsUrl, rootPath, address);
    }

    public Void call() throws IOException {
        System.out.println("Starting data node");
        Configuration conf = new Configuration();
        conf.set("fs.default.name", this.hdfsUrl);
        conf.set("dfs.data.dir", new File(new File(this.rootPath), "hadoop/datanode").getAbsolutePath());
        conf.set("dfs.datanode.address", "0.0.0.0:0");
        conf.set("dfs.datanode.http.address", "0.0.0.0:0");
        conf.set("dfs.datanode.ipc.address", "0.0.0.0:0");
        conf.set("slave.host.name", this.slaveHostName);
        conf.setLong("dfs.datanode.du.reserved", 0x280000000L);
        DataNode dn = DataNode.instantiateDataNode((String[])new String[0], (Configuration)conf);
        DataNode.runDatanodeDaemon((DataNode)dn);
        return null;
    }
}

