/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.hadoop;

import hudson.remoting.Callable;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NameNodeStartTask
implements Callable<Void, IOException> {
    private final File hudsonRoot;
    private final String hdfsUrl;
    private final int hdfsPort;
    private boolean format = Boolean.getBoolean("hadoop.format");
    private static final long serialVersionUID = 1L;
    public static final int HTTP_PORT = 50070;

    NameNodeStartTask(File hudsonRoot, String hdfsUrl, int hdfsPort) {
        this.hudsonRoot = hudsonRoot;
        this.hdfsUrl = hdfsUrl;
        this.hdfsPort = hdfsPort;
    }

    public Void call() throws IOException {
        File hadoopRoot = new File(this.hudsonRoot, "hadoop");
        if (hadoopRoot.mkdirs()) {
            this.format = true;
        }
        Configuration conf = new Configuration();
        conf.set("fs.default.name", this.hdfsUrl);
        conf.set("dfs.http.address", "0.0.0.0:50070");
        File namedir = new File(hadoopRoot, "namedir");
        if (namedir.mkdirs()) {
            this.format = true;
        }
        conf.set("dfs.name.dir", namedir.getPath());
        File datadir = new File(hadoopRoot, "datadir");
        if (datadir.mkdirs()) {
            this.format = true;
        }
        conf.set("dfs.data.dir", datadir.getPath());
        conf.setInt("dfs.replication", 1);
        if (this.format) {
            System.out.println("Formatting HDFS");
            NameNode.format((Configuration)conf);
        }
        System.out.println("Starting namenode");
        NameNode.createNameNode((String[])new String[0], (Configuration)conf);
        return null;
    }
}

