/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.hadoop;

import hudson.FilePath;
import hudson.Plugin;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.hadoop.HadoopPage;
import hudson.remoting.Channel;
import hudson.slaves.Channels;
import hudson.util.ClasspathBuilder;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;

public class PluginImpl
extends Plugin {
    Channel channel;
    HadoopPage page = new HadoopPage();
    private String masterHostName;
    public static final int JOB_TRACKER_PORT_NUMBER = 50040;
    private static final Logger LOGGER = Logger.getLogger(PluginImpl.class.getName());

    public void start() throws Exception {
        Hudson.getInstance().getActions().add(this.page);
    }

    public String getHdfsUrl() throws MalformedURLException {
        InetSocketAddress a = this.getHdfsAddress();
        if (a == null) {
            return null;
        }
        return "hdfs://" + a.getHostName() + ":" + a.getPort() + "/";
    }

    public InetSocketAddress getHdfsAddress() throws MalformedURLException {
        if (this.masterHostName == null) {
            return null;
        }
        return new InetSocketAddress(this.masterHostName, 9000);
    }

    public DFSClient createDFSClient() throws IOException {
        return new DFSClient(this.getHdfsAddress(), new Configuration(false));
    }

    public String getJobTrackerAddress() throws MalformedURLException {
        if (this.masterHostName == null) {
            return null;
        }
        return this.masterHostName + ":" + 50040;
    }

    static Channel createHadoopVM(File rootDir, TaskListener listener) throws IOException, InterruptedException {
        rootDir = new File(rootDir, "hadoop");
        FilePath distDir = new FilePath(new File(rootDir, "dist"));
        distDir.installIfNecessaryFrom(PluginImpl.class.getResource("hadoop.tar.gz"), listener, "Hadoop");
        File logDir = new File(rootDir, "logs");
        logDir.mkdirs();
        return Channels.newJVM((String)"Hadoop", (TaskListener)listener, null, (ClasspathBuilder)new ClasspathBuilder().addAll(distDir, "hadoop-*-core.jar").addAll(distDir, "lib/**/*.jar").add(distDir.child("conf")), Collections.singletonMap("hadoop.log.dir", logDir.getAbsolutePath()));
    }

    String getMasterHostName() throws IOException, InterruptedException {
        Hudson h = Hudson.getInstance();
        String rootUrl = h.getRootUrl();
        if (rootUrl == null) {
            String real = h.toComputer().getHostName();
            LOGGER.fine("Hudson root URL isn't configured. Using " + real + " instead");
            return real;
        }
        String hostName = new URL(rootUrl).getHost();
        final ServerSocket ss = new ServerSocket(0);
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ss.accept();
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, "Failed to accept", e);
                }
                finally {
                    try {
                        ss.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        t.start();
        try {
            Socket s = new Socket();
            s.connect(new InetSocketAddress(hostName, ss.getLocalPort()), 1000);
            s.close();
            return hostName;
        }
        catch (IOException e) {
            String real = h.toComputer().getHostName();
            LOGGER.fine("Hudson root URL " + rootUrl + " looks like a front end. Using " + real + " instead");
            return real;
        }
    }

    public void postInit() throws IOException, InterruptedException {
        this.masterHostName = this.getMasterHostName();
    }

    public void stop() throws Exception {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    public static PluginImpl get() {
        return (PluginImpl)Hudson.getInstance().getPlugin(PluginImpl.class);
    }
}

