/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.heavy_job;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Executor;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Queue;
import hudson.model.queue.AbstractSubTask;
import hudson.model.queue.SubTask;
import hudson.plugins.heavy_job.Messages;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeavyJobProperty
extends JobProperty<AbstractProject<?, ?>> {
    public final int weight;

    @DataBoundConstructor
    public HeavyJobProperty(int weight) {
        this.weight = weight;
    }

    public List<SubTask> getSubTasks() {
        ArrayList<SubTask> r = new ArrayList<SubTask>();
        for (int i = 1; i < this.weight; ++i) {
            r.add((SubTask)new AbstractSubTask(){

                public Queue.Executable createExecutable() throws IOException {
                    return new ExecutableImpl((SubTask)this);
                }

                public Object getSameNodeConstraint() {
                    return this.getProject();
                }

                public long getEstimatedDuration() {
                    return this.getProject().getEstimatedDuration();
                }

                public Queue.Task getOwnerTask() {
                    return this.getProject();
                }

                public String getDisplayName() {
                    return Messages.HeavyJobProperty_SubTaskDisplayName(this.getProject().getDisplayName());
                }

                private AbstractProject<?, ?> getProject() {
                    return (AbstractProject)HeavyJobProperty.this.owner;
                }
            });
        }
        return r;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExecutableImpl
    implements Queue.Executable {
        private final SubTask parent;
        private final Executor executor = Executor.currentExecutor();

        private ExecutableImpl(SubTask parent) {
            this.parent = parent;
        }

        public SubTask getParent() {
            return this.parent;
        }

        public AbstractBuild<?, ?> getBuild() {
            return (AbstractBuild)this.executor.getCurrentWorkUnit().context.getPrimaryWorkUnit().getExecutable();
        }

        public void run() {
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public String getDisplayName() {
            return Messages.HeavyJobProperty_DisplayName();
        }
    }
}

