/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.hgca;

import hudson.MarkupText;
import hudson.model.AbstractBuild;
import hudson.plugins.hgca.HGCALinkAnnotator;
import hudson.plugins.hgca.HGCAProjectProperty;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HGCALinkAnnotator
extends ChangeLogAnnotator {
    public void annotate(AbstractBuild<?, ?> build, ChangeLogSet.Entry change, MarkupText text) {
        HGCAProjectProperty hpp = (HGCAProjectProperty)build.getProject().getProperty(HGCAProjectProperty.class);
        if (hpp == null) {
            return;
        }
        HashMap annoPats = hpp.getAnnotations();
        if (annoPats.size() == 0) {
            return;
        }
        this.annotate(annoPats, text);
    }

    void annotate(HashMap<String, String> annoPats, MarkupText text) {
        ArrayList patternMarkups = this.createLinkMarkups(annoPats);
        for (LinkMarkup markup : patternMarkups) {
            markup.process(text);
        }
    }

    private ArrayList<LinkMarkup> createLinkMarkups(HashMap<String, String> annoPats) {
        ArrayList<LinkMarkup> lm = new ArrayList<LinkMarkup>();
        for (Map.Entry<String, String> entry : annoPats.entrySet()) {
            lm.add(new LinkMarkup(entry.getKey(), entry.getValue()));
        }
        return lm;
    }
}

