/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.hgca;

import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HGCAProjectProperty
extends JobProperty<AbstractProject<?, ?>> {
    public final HashMap<String, String> annoPats;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public HGCAProjectProperty(List<Entry> annoPats) {
        this.annoPats = HGCAProjectProperty.toMap(annoPats);
    }

    public HGCAProjectProperty(Entry ... annoPats) {
        this(Arrays.asList(annoPats));
    }

    public boolean useAnnotations() {
        return this.getAnnotations().size() != 0;
    }

    public HashMap<String, String> getAnnotations() {
        HashMap<String, String> allAnnos = new HashMap<String, String>();
        if (DESCRIPTOR.getGlobalAnnotations() != null && DESCRIPTOR.getGlobalAnnotations().size() > 0) {
            allAnnos.putAll(DESCRIPTOR.getGlobalAnnotations());
        }
        allAnnos.putAll(this.annoPats);
        return allAnnos;
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    private static HashMap<String, String> toMap(List<Entry> entries) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (entries != null && entries.size() > 0) {
            for (Entry entry : entries) {
                map.put(entry.key, entry.value);
            }
        }
        return map;
    }

    public static class Entry {
        public String key;
        public String value;

        @DataBoundConstructor
        public Entry(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        private HashMap<String, String> globalAnnotations;

        public DescriptorImpl() {
            super(HGCAProjectProperty.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return AbstractProject.class.isAssignableFrom(jobType);
        }

        public HashMap<String, String> getGlobalAnnotations() {
            return this.globalAnnotations;
        }

        public String getDisplayName() {
            return "HGCA pattern/URL annotation pairs";
        }

        public boolean configure(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
            HGCAProjectProperty hpp = (HGCAProjectProperty)((Object)req.bindJSON(HGCAProjectProperty.class, o));
            if (hpp.annoPats.size() > 0) {
                this.globalAnnotations = hpp.annoPats;
            }
            this.save();
            return super.configure(req);
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            System.err.println(formData.toString());
            JSONObject toBind = formData.has("annoBlock") ? formData.getJSONObject("annoBlock") : formData;
            HGCAProjectProperty hpp = (HGCAProjectProperty)((Object)req.bindJSON(HGCAProjectProperty.class, toBind));
            if (hpp.getAnnotations().size() == 0) {
                hpp = null;
            }
            return hpp;
        }
    }
}

