/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.hgca;

import hudson.MarkupText;
import hudson.model.AbstractBuild;
import hudson.plugins.hgca.HGCAProjectProperty;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HGCALinkAnnotator
extends ChangeLogAnnotator {
    public void annotate(AbstractBuild<?, ?> build, ChangeLogSet.Entry change, MarkupText text) {
        HashMap<String, String> annoPats;
        HGCAProjectProperty hpp = (HGCAProjectProperty)build.getProject().getProperty(HGCAProjectProperty.class);
        HGCAProjectProperty.DescriptorImpl descriptor = HGCAProjectProperty.DescriptorImpl.get();
        if (hpp == null && !descriptor.getAlwaysApply()) {
            return;
        }
        HashMap<String, String> hashMap = annoPats = hpp != null ? hpp.getAnnotations() : descriptor.getGlobalAnnotations();
        if (annoPats.isEmpty()) {
            return;
        }
        this.annotate(annoPats, text);
    }

    void annotate(HashMap<String, String> annoPats, MarkupText text) {
        for (Map.Entry<String, String> entry : annoPats.entrySet()) {
            new LinkMarkup(entry.getKey(), entry.getValue()).process(text);
        }
    }

    private static final class LinkMarkup {
        private final Pattern pattern;
        private final String href;
        private static final Pattern NUM_PATTERN = Pattern.compile("NUM");
        private static final Pattern ANYWORD_PATTERN = Pattern.compile("ANYWORD");

        LinkMarkup(String pattern, String href) {
            pattern = NUM_PATTERN.matcher(pattern).replaceAll("(\\\\d+)");
            pattern = ANYWORD_PATTERN.matcher(pattern).replaceAll("([\\\\w.-]+)");
            this.pattern = Pattern.compile(pattern, 2);
            this.href = href;
        }

        void process(MarkupText text) {
            for (MarkupText.SubText st : text.findTokens(this.pattern)) {
                st.surroundWith("<a href=\"" + this.href + "\">", "</a>");
            }
        }
    }
}

