/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.hgca;

import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.hgca.Messages;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HGCAProjectProperty
extends JobProperty<AbstractProject<?, ?>> {
    public final HashMap<String, String> annoPats;
    private final Boolean applyGlobal;

    @DataBoundConstructor
    public HGCAProjectProperty(List<Entry> annoPats, Boolean applyGlobal) {
        this.annoPats = HGCAProjectProperty.toMap(annoPats);
        this.applyGlobal = applyGlobal;
    }

    public HGCAProjectProperty(boolean applyGlobal, Entry ... annoPats) {
        this(Arrays.asList(annoPats), applyGlobal);
    }

    public HashMap<String, String> getAnnotations() {
        HashMap<String, String> allAnnos = new HashMap<String, String>();
        if (this.getApplyGlobal()) {
            allAnnos.putAll(DescriptorImpl.get().getGlobalAnnotations());
        }
        allAnnos.putAll(this.annoPats);
        return allAnnos;
    }

    public boolean getApplyGlobal() {
        return this.applyGlobal == null || this.applyGlobal != false;
    }

    private static HashMap<String, String> toMap(List<Entry> entries) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (entries != null && entries.size() > 0) {
            for (Entry entry : entries) {
                map.put(entry.key, entry.value);
            }
        }
        return map;
    }

    public static class Entry {
        public String key;
        public String value;

        @DataBoundConstructor
        public Entry(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        private HashMap<String, String> globalAnnotations = new HashMap();
        private Boolean alwaysApply;

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return AbstractProject.class.isAssignableFrom(jobType);
        }

        public HashMap<String, String> getGlobalAnnotations() {
            return this.globalAnnotations;
        }

        public boolean getAlwaysApply() {
            return this.alwaysApply != null && this.alwaysApply != false;
        }

        public String getDisplayName() {
            return Messages.DisplayName();
        }

        public boolean configure(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
            HGCAProjectProperty hpp = (HGCAProjectProperty)((Object)req.bindJSON(HGCAProjectProperty.class, o));
            this.globalAnnotations = hpp.annoPats;
            this.alwaysApply = o.getBoolean("alwaysApply");
            this.save();
            return super.configure(req, o);
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            HGCAProjectProperty hpp = null;
            if (formData.has("annoBlock")) {
                hpp = (HGCAProjectProperty)((Object)req.bindJSON(HGCAProjectProperty.class, formData.getJSONObject("annoBlock")));
            }
            return hpp;
        }

        static DescriptorImpl get() {
            return (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
        }
    }
}

