/*
 * Decompiled with CFR 0.152.
 */
package htmlpublisher;

import htmlpublisher.HtmlPublisherTarget;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Run;
import java.io.File;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlPublisherTarget {
    private final String reportName;
    private final String reportDir;
    private final String reportFiles;
    private final boolean keepAll;
    private final String wrapperName = "htmlpublisher-wrapper.html";

    @DataBoundConstructor
    public HtmlPublisherTarget(String reportName, String reportDir, String reportFiles, boolean keepAll) {
        this.reportName = reportName;
        this.reportDir = reportDir;
        this.reportFiles = reportFiles;
        this.keepAll = keepAll;
    }

    public String getReportName() {
        return this.reportName;
    }

    public String getReportDir() {
        return this.reportDir;
    }

    public String getReportFiles() {
        return this.reportFiles;
    }

    public boolean getKeepAll() {
        return this.keepAll;
    }

    public String getSanitizedName() {
        String safeName = this.reportName;
        safeName = safeName.replace(" ", "_");
        return safeName;
    }

    public String getWrapperName() {
        this.getClass();
        return "htmlpublisher-wrapper.html";
    }

    public FilePath getArchiveTarget(AbstractBuild build) {
        return new FilePath(this.keepAll ? this.getBuildArchiveDir((Run)build) : this.getProjectArchiveDir((AbstractItem)build.getProject()));
    }

    private File getProjectArchiveDir(AbstractItem project) {
        return new File(new File(project.getRootDir(), "htmlreports"), this.getSanitizedName());
    }

    private File getBuildArchiveDir(Run run) {
        return new File(new File(run.getRootDir(), "htmlreports"), this.getSanitizedName());
    }

    public void handleAction(AbstractBuild<?, ?> build) {
        if (this.keepAll) {
            build.addAction((Action)new HTMLBuildAction(this, build, this));
        }
    }

    public Action getProjectAction(AbstractProject project) {
        return new HTMLAction(this, (AbstractItem)project, this);
    }

    static /* synthetic */ String access$000(HtmlPublisherTarget x0) {
        return x0.reportName;
    }

    static /* synthetic */ File access$100(HtmlPublisherTarget x0, Run x1) {
        return x0.getBuildArchiveDir(x1);
    }

    static /* synthetic */ File access$200(HtmlPublisherTarget x0, AbstractItem x1) {
        return x0.getProjectArchiveDir(x1);
    }
}

