/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.bot;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Executor;
import hudson.model.Hudson;
import hudson.plugins.im.bot.AbstractSingleJobCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbortCommand
extends AbstractSingleJobCommand {
    private static final String HELP = " <job> - specify which job to abort";

    public String getHelp() {
        return HELP;
    }

    protected CharSequence getMessageForJob(AbstractProject<?, ?> project, String sender) {
        if (!project.isInQueue() && !project.isBuilding()) {
            return sender + ": how do you intend a build that isn't building?";
        }
        boolean aborted = false;
        if (project.isInQueue()) {
            aborted = Hudson.getInstance().getQueue().cancel(project);
        }
        if (!aborted) {
            AbstractBuild build = (AbstractBuild)project.getLastBuild();
            if (build == null) {
                return sender + ": it appears this job has never been built";
            }
            Executor ex = build.getExecutor();
            if (ex == null) {
                aborted = false;
            } else {
                ex.interrupt();
            }
        }
        if (aborted) {
            return project.getName() + " aborted, I hope you're happy!";
        }
        return sender + ": " + " couldn't abort " + project.getName() + ". I don't know why this happened.";
    }
}

