/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.bot;

import hudson.plugins.im.IMChat;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessage;
import hudson.plugins.im.IMMessageListener;
import hudson.plugins.im.bot.AbortCommand;
import hudson.plugins.im.bot.BotCommand;
import hudson.plugins.im.bot.BuildCommand;
import hudson.plugins.im.bot.HealthCommand;
import hudson.plugins.im.bot.QueueCommand;
import hudson.plugins.im.bot.SetAliasCommand;
import hudson.plugins.im.bot.SnackCommand;
import hudson.plugins.im.bot.StatusCommand;
import hudson.plugins.im.bot.TestResultCommand;
import hudson.plugins.im.tools.ExceptionHelper;
import hudson.plugins.im.tools.MessageHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bot
implements IMMessageListener {
    private static final Logger LOGGER = Logger.getLogger(Bot.class.getName());
    private static final BotCommand STATUS_COMMAND = new StatusCommand();
    private static final BotCommand HEALTH_COMMAND = new HealthCommand();
    private static final BotCommand QUEUE_COMMAND = new QueueCommand();
    private static final BotCommand SNACK_COMMAND = new SnackCommand();
    private static final BotCommand TESTRESULTS_COMMAND = new TestResultCommand();
    private static final BotCommand ABORT_COMMAND = new AbortCommand();
    private static final Map<String, BotCommand> COMMAND_MAP = new HashMap<String, BotCommand>();
    private final SortedMap<String, BotCommand> cmdsAndAliases = new TreeMap<String, BotCommand>();
    private final IMChat chat;
    private final String nick;
    private final String imServer;
    private final String commandPrefix;
    private String helpCache = null;

    public Bot(IMChat chat, String nick, String imServer, String commandPrefix) {
        this.chat = chat;
        this.nick = nick;
        this.imServer = imServer;
        this.commandPrefix = commandPrefix;
        this.cmdsAndAliases.putAll(COMMAND_MAP);
        BuildCommand buildCommand = new BuildCommand(this.nick + "@" + this.imServer);
        this.cmdsAndAliases.put("build", buildCommand);
        this.cmdsAndAliases.put("schedule", buildCommand);
        this.cmdsAndAliases.put("help", new HelpCommand());
        this.cmdsAndAliases.put("alias", new SetAliasCommand(this));
        chat.addMessageListener(this);
    }

    @Override
    public void onMessage(IMMessage msg) {
        String[] args;
        String payload = this.retrieveMessagePayLoad(msg.getBody());
        if (payload != null && (args = MessageHelper.extractCommandLine(payload)).length > 0) {
            String cmd = args[0];
            String sender = msg.getFrom();
            if (sender != null) {
                sender = this.chat.getNickName(sender);
            }
            try {
                BotCommand command = (BotCommand)this.cmdsAndAliases.get(cmd);
                if (command != null) {
                    command.executeCommand(this.chat, msg, sender, args);
                } else {
                    this.chat.sendMessage(sender + " did you mean me? Unknown command '" + cmd + "'\nUse " + this.commandPrefix + "help to get help!");
                }
            }
            catch (IMException e) {
                LOGGER.warning(ExceptionHelper.dump(e));
            }
        }
    }

    private static boolean isNickSeparator(String candidate) {
        return ":".equals(candidate) || ",".equals(candidate);
    }

    private String retrieveMessagePayLoad(String body) {
        if (body == null) {
            return null;
        }
        if (body.startsWith(this.commandPrefix)) {
            return body.substring(this.commandPrefix.length()).trim();
        }
        if (body.startsWith(this.nick) && Bot.isNickSeparator(body.substring(this.nick.length(), this.nick.length() + 1))) {
            return body.substring(this.nick.length() + 1).trim();
        }
        return null;
    }

    BotCommand getCommand(String name) {
        return (BotCommand)this.cmdsAndAliases.get(name);
    }

    BotCommand addAlias(String name, BotCommand alias) {
        BotCommand old = (BotCommand)this.cmdsAndAliases.get(name);
        if (old != null && !(old instanceof SetAliasCommand.AliasCommand)) {
            throw new IllegalArgumentException("Won't override built-in command: '" + name + "'!");
        }
        this.cmdsAndAliases.put(name, alias);
        this.helpCache = null;
        return old;
    }

    SetAliasCommand.AliasCommand removeAlias(String name) {
        BotCommand alias = (BotCommand)this.cmdsAndAliases.get(name);
        if (alias instanceof SetAliasCommand.AliasCommand) {
            this.cmdsAndAliases.remove(name);
            return (SetAliasCommand.AliasCommand)alias;
        }
        if (alias != null) {
            throw new IllegalArgumentException("Won't remove built-in command: '" + name + "'!");
        }
        return null;
    }

    SortedMap<String, SetAliasCommand.AliasCommand> getAliases() {
        TreeMap<String, SetAliasCommand.AliasCommand> result = new TreeMap<String, SetAliasCommand.AliasCommand>();
        for (Map.Entry<String, BotCommand> entry : this.cmdsAndAliases.entrySet()) {
            if (!(entry.getValue() instanceof SetAliasCommand.AliasCommand)) continue;
            result.put(entry.getKey(), (SetAliasCommand.AliasCommand)entry.getValue());
        }
        return result;
    }

    public void shutdown() {
        this.chat.removeMessageListener(this);
        if (this.chat.isMultiUserChat()) {
            try {
                this.chat.sendMessage("Oops, seems like Hudson is going down now. See ya!");
            }
            catch (IMException iMException) {
                // empty catch block
            }
        }
    }

    static {
        COMMAND_MAP.put("status", STATUS_COMMAND);
        COMMAND_MAP.put("s", STATUS_COMMAND);
        COMMAND_MAP.put("health", HEALTH_COMMAND);
        COMMAND_MAP.put("h", HEALTH_COMMAND);
        COMMAND_MAP.put("jobs", STATUS_COMMAND);
        COMMAND_MAP.put("queue", QUEUE_COMMAND);
        COMMAND_MAP.put("q", QUEUE_COMMAND);
        COMMAND_MAP.put("testresult", TESTRESULTS_COMMAND);
        COMMAND_MAP.put("abort", ABORT_COMMAND);
        COMMAND_MAP.put("botsnack", SNACK_COMMAND);
    }

    private class HelpCommand
    implements BotCommand {
        private HelpCommand() {
        }

        public void executeCommand(IMChat groupChat, IMMessage message, String sender, String[] args) throws IMException {
            if (Bot.this.helpCache == null) {
                StringBuilder msg = new StringBuilder("Available commands:");
                for (Map.Entry item : Bot.this.cmdsAndAliases.entrySet()) {
                    if (item.getValue() == this || ((BotCommand)item.getValue()).getHelp() == null) continue;
                    msg.append("\n");
                    msg.append((String)item.getKey());
                    msg.append(((BotCommand)item.getValue()).getHelp());
                }
                Bot.this.helpCache = msg.toString();
            }
            groupChat.sendMessage(Bot.this.helpCache);
        }

        public String getHelp() {
            return null;
        }
    }
}

