/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.bot;

import hudson.model.AbstractProject;
import hudson.plugins.im.bot.AbstractTextSendingCommand;
import hudson.plugins.im.bot.CommandException;
import hudson.plugins.im.bot.DefaultJobProvider;
import hudson.plugins.im.bot.JobProvider;
import hudson.plugins.im.tools.MessageHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractSingleJobCommand
extends AbstractTextSendingCommand {
    private final int numberOfArguments;
    private JobProvider jobProvider = new DefaultJobProvider();

    protected AbstractSingleJobCommand() {
        this(0);
    }

    protected AbstractSingleJobCommand(int numberOfArguments) {
        this.numberOfArguments = numberOfArguments;
    }

    protected abstract CharSequence getMessageForJob(AbstractProject<?, ?> var1, String var2, String[] var3) throws CommandException;

    protected String getReply(String sender, String[] args) {
        if (args.length > 1 + this.numberOfArguments) {
            String[] remainingArgs;
            String jobName;
            if (this.numberOfArguments == 0) {
                jobName = MessageHelper.getJoinedName((String[])args, (int)1);
                remainingArgs = new String[]{};
            } else {
                jobName = args[1].replace("\"", "");
                remainingArgs = (String[])MessageHelper.copyOfRange((Object[])args, (int)2, (int)args.length);
            }
            AbstractProject job = this.jobProvider.getJobByName(jobName);
            if (job != null) {
                try {
                    return ((Object)this.getMessageForJob(job, sender, remainingArgs)).toString();
                }
                catch (CommandException e) {
                    return this.getErrorReply(sender, e);
                }
            }
            return sender + ": unknown job '" + jobName + "'";
        }
        if (this.numberOfArguments == 0) {
            return sender + ": you must specify a job name";
        }
        return sender + ": you must specify a job name and " + this.numberOfArguments + " additional arguments";
    }

    void setJobProvider(JobProvider jobProvider) {
        this.jobProvider = jobProvider;
    }
}

