/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im;

import hudson.model.Hudson;
import hudson.plugins.im.DummyConnection;
import hudson.plugins.im.IMConnection;
import hudson.plugins.im.IMConnectionListener;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMPublisherDescriptor;
import hudson.plugins.im.tools.ExceptionHelper;
import hudson.util.TimeUnit2;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;

public abstract class IMConnectionProvider
implements IMConnectionListener {
    private static final Logger LOGGER = Logger.getLogger(IMConnectionProvider.class.getName());
    private static final IMConnection NULL_CONNECTION = new DummyConnection();
    protected IMPublisherDescriptor descriptor;
    private IMConnection imConnection;
    private Authentication authentication = null;
    private final ConnectorRunnable connector = new ConnectorRunnable();

    protected IMConnectionProvider() {
        Thread connectorThread = new Thread((Runnable)this.connector, "IM-Reconnector-Thread");
        connectorThread.setDaemon(true);
        connectorThread.start();
    }

    public abstract IMConnection createConnection() throws IMException;

    public synchronized IMConnection currentConnection() {
        if (this.imConnection == null) {
            try {
                this.imConnection = this.createConnection();
            }
            catch (IMException e) {
                this.tryReconnect();
                return NULL_CONNECTION;
            }
            if (this.imConnection != null) {
                this.imConnection.addConnectionListener(this);
                return this.imConnection;
            }
            if (this.descriptor != null) {
                this.tryReconnect();
            }
            return NULL_CONNECTION;
        }
        return this.imConnection;
    }

    public synchronized void releaseConnection() {
        if (this.imConnection != null) {
            this.imConnection.removeConnectionListener(this);
            this.imConnection.close();
            this.imConnection = null;
        }
    }

    protected IMPublisherDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(IMPublisherDescriptor desc) {
        this.descriptor = desc;
        if (desc.getHudsonUserName() != null) {
            try {
                UsernamePasswordAuthenticationToken tmp = new UsernamePasswordAuthenticationToken((Object)desc.getHudsonUserName(), (Object)desc.getHudsonPassword());
                this.authentication = Hudson.getInstance().getSecurityRealm().getSecurityComponents().manager.authenticate((Authentication)tmp);
            }
            catch (AuthenticationException e) {
                LOGGER.warning(this.descriptor.getPluginDescription() + " couldn't authenticate against Hudson: " + (Object)((Object)e));
            }
        }
    }

    public void connectionBroken(Exception e) {
        this.tryReconnect();
    }

    private void tryReconnect() {
        this.connector.semaphore.release();
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    private final class ConnectorRunnable
    implements Runnable {
        private final Semaphore semaphore = new Semaphore(0);
        private boolean firstConnect = true;

        private ConnectorRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                block9: while (true) {
                    this.semaphore.acquire();
                    if (!this.firstConnect) {
                        TimeUnit.SECONDS.sleep(30L);
                        LOGGER.info("Trying to reconnect");
                    } else {
                        this.firstConnect = false;
                        LOGGER.info("Trying to connect");
                    }
                    boolean success = false;
                    int timeout = 1;
                    while (true) {
                        if (success) continue block9;
                        IMConnectionProvider iMConnectionProvider = IMConnectionProvider.this;
                        synchronized (iMConnectionProvider) {
                            if (IMConnectionProvider.this.imConnection != null) {
                                try {
                                    IMConnectionProvider.this.releaseConnection();
                                }
                                catch (Exception e) {
                                    LOGGER.warning(ExceptionHelper.dump(e));
                                }
                            }
                            try {
                                IMConnectionProvider.this.imConnection = IMConnectionProvider.this.createConnection();
                                if (IMConnectionProvider.this.imConnection != null) {
                                    success = true;
                                }
                            }
                            catch (IMException e) {
                                // empty catch block
                            }
                        }
                        if (!success) {
                            LOGGER.info("Reconnect failed. Next connection attempt in " + timeout + " minutes");
                            TimeUnit2.MINUTES.sleep((long)timeout);
                            timeout *= 2;
                            continue;
                        }
                        this.semaphore.drainPermits();
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                LOGGER.info("Connect thread interrupted");
                return;
            }
        }
    }
}

