/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.bot;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.im.bot.AbstractMultipleJobCommand;
import hudson.plugins.im.tools.MessageHelper;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusCommand
extends AbstractMultipleJobCommand {
    public Collection<String> getCommandNames() {
        return Arrays.asList("status", "s", "jobs");
    }

    protected CharSequence getMessageForJob(AbstractProject<?, ?> project) {
        AbstractBuild lastBuild;
        StringBuilder msg = new StringBuilder(32);
        msg.append(project.getFullDisplayName());
        if (project.isDisabled()) {
            msg.append("(disabled) ");
        } else if (project.isBuilding()) {
            msg.append("(BUILDING: ").append(((AbstractBuild)project.getLastBuild()).getDurationString()).append(")");
        } else if (project.isInQueue()) {
            msg.append("(in queue) ");
        }
        msg.append(": ");
        for (lastBuild = (AbstractBuild)project.getLastBuild(); lastBuild != null && lastBuild.isBuilding(); lastBuild = (AbstractBuild)lastBuild.getPreviousBuild()) {
        }
        if (lastBuild != null) {
            msg.append("last build: ").append(lastBuild.getNumber()).append(" (").append(lastBuild.getTimestampString()).append(" ago): ").append(lastBuild.getResult()).append(": ").append(MessageHelper.getBuildURL((AbstractBuild)lastBuild));
        } else {
            msg.append("no finished build yet");
        }
        return msg;
    }

    protected String getCommandShortName() {
        return "status";
    }
}

