/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.bot;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.im.bot.AbstractMultipleJobCommand;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.test.AbstractTestResultAction;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResultCommand
extends AbstractMultipleJobCommand {
    public Collection<String> getCommandNames() {
        return Collections.singleton("testresult");
    }

    protected String getCommandShortName() {
        return "test results";
    }

    protected CharSequence getMessageForJob(AbstractProject<?, ?> job) {
        AbstractBuild build = (AbstractBuild)job.getLastCompletedBuild();
        if (build == null) {
            return job.getFullDisplayName() + " has never been built";
        }
        AbstractTestResultAction tests = build.getTestResultAction();
        if (tests == null) {
            return job.getFullDisplayName() + ": latest build contains no test results";
        }
        StringBuilder listing = new StringBuilder(String.format("%s build #%s had %s of %s tests fail\n", job.getFullDisplayName(), build.getNumber(), tests.getFailCount(), tests.getTotalCount()));
        listing.append("\n");
        List failedTests = tests.getFailedTests();
        for (CaseResult result : failedTests) {
            listing.append(String.format("%s failed in %ss\n", result.getFullName(), Float.valueOf(result.getDuration())));
        }
        return listing;
    }
}

