/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.tools;

import hudson.model.AbstractBuild;
import hudson.model.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildHelper {
    private BuildHelper() {
    }

    public static boolean isFix(AbstractBuild<?, ?> build) {
        if (build.getResult() != Result.SUCCESS) {
            return false;
        }
        AbstractBuild<?, ?> previousBuild = BuildHelper.getPreviousNonAbortedBuild(build);
        if (previousBuild != null) {
            return previousBuild.getResult().isWorseThan(Result.SUCCESS);
        }
        return false;
    }

    public static boolean isFailureOrUnstable(AbstractBuild<?, ?> build) {
        return build.getResult() == Result.FAILURE || build.getResult() == Result.UNSTABLE;
    }

    public static boolean isStillFailureOrUnstable(AbstractBuild<?, ?> build) {
        ExtResult result = BuildHelper.getExtendedResult(build);
        return result == ExtResult.STILL_FAILING || result == ExtResult.STILL_UNSTABLE;
    }

    public static AbstractBuild<?, ?> getPreviousNonAbortedBuild(AbstractBuild<?, ?> build) {
        AbstractBuild previousBuild;
        for (previousBuild = (AbstractBuild)build.getPreviousBuild(); previousBuild != null; previousBuild = (AbstractBuild)previousBuild.getPreviousBuild()) {
            if (previousBuild.getResult() == Result.ABORTED || previousBuild.getResult() == Result.NOT_BUILT) {
                continue;
            }
            return previousBuild;
        }
        return previousBuild;
    }

    public static AbstractBuild<?, ?> getPreviousSuccessfulBuild(AbstractBuild<?, ?> build) {
        for (AbstractBuild previousBuild = (AbstractBuild)build.getPreviousBuild(); previousBuild != null; previousBuild = (AbstractBuild)previousBuild.getPreviousBuild()) {
            if (previousBuild.getResult() != Result.SUCCESS) {
                continue;
            }
            return previousBuild;
        }
        return null;
    }

    public static String getResultDescription(AbstractBuild<?, ?> build) {
        ExtResult result = BuildHelper.getExtendedResult(build);
        return result.toString();
    }

    public static ExtResult getExtendedResult(AbstractBuild<?, ?> build) {
        Result result = build.getResult();
        if (result == Result.ABORTED) {
            return ExtResult.ABORTED;
        }
        if (result == Result.NOT_BUILT) {
            return ExtResult.NOT_BUILT;
        }
        if (result == Result.SUCCESS) {
            if (BuildHelper.isFix(build)) {
                return ExtResult.FIXED;
            }
            return ExtResult.SUCCESS;
        }
        AbstractBuild<?, ?> previousBuild = BuildHelper.getPreviousNonAbortedBuild(build);
        if (result == Result.UNSTABLE) {
            if (previousBuild != null && previousBuild.getResult() == Result.UNSTABLE) {
                return ExtResult.STILL_UNSTABLE;
            }
            return ExtResult.UNSTABLE;
        }
        if (result == Result.FAILURE) {
            if (previousBuild != null && previousBuild.getResult() == Result.FAILURE) {
                return ExtResult.STILL_FAILING;
            }
            return ExtResult.FAILURE;
        }
        throw new IllegalArgumentException("Unknown result: '" + result + "' for build: " + build);
    }

    public static String getProjectName(AbstractBuild<?, ?> build) {
        return build.getProject().getFullDisplayName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExtResult {
        FIXED,
        SUCCESS,
        STILL_UNSTABLE("STILL UNSTABLE"),
        UNSTABLE,
        STILL_FAILING("STILL FAILING"),
        FAILURE,
        ABORTED,
        NOT_BUILT("NOT BUILT");

        private final String description;

        private ExtResult() {
            this.description = null;
        }

        private ExtResult(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description != null ? this.description : super.toString();
        }
    }
}

