/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Fingerprint;
import hudson.model.User;
import hudson.plugins.im.DummyConnection;
import hudson.plugins.im.GroupChatIMMessageTarget;
import hudson.plugins.im.IMConnection;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessageTarget;
import hudson.plugins.im.IMMessageTargetConversionException;
import hudson.plugins.im.IMMessageTargetConverter;
import hudson.plugins.im.IMPublisherDescriptor;
import hudson.plugins.im.NotificationStrategy;
import hudson.plugins.im.build_notify.BuildToChatNotifier;
import hudson.plugins.im.build_notify.DefaultBuildToChatNotifier;
import hudson.plugins.im.tools.Assert;
import hudson.plugins.im.tools.BuildHelper;
import hudson.plugins.im.tools.ExceptionHelper;
import hudson.scm.ChangeLogSet;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public abstract class IMPublisher
extends Notifier
implements BuildStep {
    private static final Logger LOGGER = Logger.getLogger(IMPublisher.class.getName());
    private List<IMMessageTarget> targets;
    @Deprecated
    private hudson.plugins.jabber.NotificationStrategy notificationStrategy;
    private NotificationStrategy strategy;
    private final boolean notifyOnBuildStart;
    private final boolean notifySuspects;
    private final boolean notifyCulprits;
    private final boolean notifyFixers;
    private final boolean notifyUpstreamCommitters;
    private BuildToChatNotifier buildToChatNotifier;
    @Deprecated
    private transient String defaultIdSuffix;

    @Deprecated
    protected IMPublisher(List<IMMessageTarget> defaultTargets, String notificationStrategyString, boolean notifyGroupChatsOnBuildStart, boolean notifySuspects, boolean notifyCulprits, boolean notifyFixers, boolean notifyUpstreamCommitters) {
        this(defaultTargets, notificationStrategyString, notifyGroupChatsOnBuildStart, notifySuspects, notifyCulprits, notifyFixers, notifyUpstreamCommitters, (BuildToChatNotifier)new DefaultBuildToChatNotifier());
    }

    protected IMPublisher(List<IMMessageTarget> defaultTargets, String notificationStrategyString, boolean notifyGroupChatsOnBuildStart, boolean notifySuspects, boolean notifyCulprits, boolean notifyFixers, boolean notifyUpstreamCommitters, BuildToChatNotifier buildToChatNotifier) {
        this.targets = defaultTargets != null ? defaultTargets : Collections.emptyList();
        NotificationStrategy strategy = NotificationStrategy.forDisplayName((String)notificationStrategyString);
        if (strategy == null) {
            strategy = NotificationStrategy.STATECHANGE_ONLY;
        }
        this.strategy = strategy;
        this.notifyOnBuildStart = notifyGroupChatsOnBuildStart;
        this.notifySuspects = notifySuspects;
        this.notifyCulprits = notifyCulprits;
        this.notifyFixers = notifyFixers;
        this.notifyUpstreamCommitters = notifyUpstreamCommitters;
        this.buildToChatNotifier = buildToChatNotifier;
    }

    public boolean needsToRunAfterFinalized() {
        return this.notifyUpstreamCommitters;
    }

    protected abstract String getPluginName();

    protected abstract IMConnection getIMConnection() throws IMException;

    protected NotificationStrategy getNotificationStrategy() {
        return this.strategy;
    }

    protected void setNotificationStrategy(NotificationStrategy strategy) {
        this.strategy = strategy;
    }

    public BuildToChatNotifier getBuildToChatNotifier() {
        return this.buildToChatNotifier;
    }

    public List<IMMessageTarget> getNotificationTargets() {
        return this.targets;
    }

    protected List<IMMessageTarget> calculateTargets() {
        if (this.getNotificationTargets() != null && this.getNotificationTargets().size() > 0) {
            return this.getNotificationTargets();
        }
        return ((IMPublisherDescriptor)this.getDescriptor()).getDefaultTargets();
    }

    public String getTargets() {
        if (this.targets == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (IMMessageTarget t : this.targets) {
            sb.append(this.getIMDescriptor().getIMMessageTargetConverter().toString(t));
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    @Deprecated
    protected void setTargets(String targetsAsString) throws IMMessageTargetConversionException {
        this.targets = new LinkedList();
        String[] split = targetsAsString.split("\\s");
        IMMessageTargetConverter conv = this.getIMDescriptor().getIMMessageTargetConverter();
        for (String fragment : split) {
            IMMessageTarget createIMMessageTarget = conv.fromString(fragment);
            if (createIMMessageTarget == null) continue;
            this.targets.add(createIMMessageTarget);
        }
    }

    @Deprecated
    protected void setNotificationTargets(List<IMMessageTarget> targets) {
        this.targets = targets != null ? targets : Collections.emptyList();
    }

    public final String getStrategy() {
        return this.getNotificationStrategy().getDisplayName();
    }

    public final boolean getNotifyOnStart() {
        return this.notifyOnBuildStart;
    }

    public final boolean getNotifySuspects() {
        return this.notifySuspects;
    }

    public final boolean getNotifyCulprits() {
        return this.notifyCulprits;
    }

    public final boolean getNotifyFixers() {
        return this.notifyFixers;
    }

    public final boolean getNotifyUpstreamCommitters() {
        return this.notifyUpstreamCommitters;
    }

    protected void log(BuildListener listener, String message) {
        listener.getLogger().append(this.getPluginName()).append(": ").append(message).append("\n");
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener buildListener) throws InterruptedException, IOException {
        Assert.isNotNull(build, (String)"Parameter 'build' must not be null.");
        Assert.isNotNull((Object)buildListener, (String)"Parameter 'buildListener' must not be null.");
        if (this.getNotificationStrategy().notificationWanted(build)) {
            this.notifyChats(build, buildListener);
        }
        if (BuildHelper.isStillFailureOrUnstable(build)) {
            String message;
            if (this.notifySuspects) {
                this.log(buildListener, "Notifying suspects");
                message = this.getBuildToChatNotifier().suspectMessage(this, build, buildListener, false);
                for (IMMessageTarget target : this.calculateIMTargets(IMPublisher.getCommitters(build), buildListener)) {
                    try {
                        this.log(buildListener, "Sending notification to suspect: " + target.toString());
                        this.sendNotification(message, target, buildListener);
                    }
                    catch (Throwable e) {
                        this.log(buildListener, "There was an error sending suspect notification to: " + target.toString());
                    }
                }
            }
            if (this.notifyCulprits) {
                this.log(buildListener, "Notifying culprits");
                message = this.getBuildToChatNotifier().culpritMessage(this, build, buildListener);
                for (IMMessageTarget target : this.calculateIMTargets(IMPublisher.getCulpritsOnly(build), buildListener)) {
                    try {
                        this.log(buildListener, "Sending notification to culprit: " + target.toString());
                        this.sendNotification(message, target, buildListener);
                    }
                    catch (Throwable e) {
                        this.log(buildListener, "There was an error sending culprit notification to: " + target.toString());
                    }
                }
            }
        } else if (BuildHelper.isFailureOrUnstable(build)) {
            boolean committerNotified = false;
            if (this.notifySuspects) {
                this.log(buildListener, "Notifying suspects");
                String message = this.getBuildToChatNotifier().suspectMessage(this, build, buildListener, true);
                for (IMMessageTarget target : this.calculateIMTargets(IMPublisher.getCommitters(build), buildListener)) {
                    try {
                        this.log(buildListener, "Sending notification to suspect: " + target.toString());
                        this.sendNotification(message, target, buildListener);
                        committerNotified = true;
                    }
                    catch (Throwable e) {
                        this.log(buildListener, "There was an error sending suspect notification to: " + target.toString());
                    }
                }
            }
            if (this.notifyUpstreamCommitters && !committerNotified) {
                this.notifyUpstreamCommitters(build, buildListener);
            }
        }
        if (this.notifyFixers && BuildHelper.isFix(build)) {
            buildListener.getLogger().append("Notifying fixers\n");
            String message = this.getBuildToChatNotifier().fixerMessage(this, build, buildListener);
            for (IMMessageTarget target : this.calculateIMTargets(IMPublisher.getCommitters(build), buildListener)) {
                try {
                    this.log(buildListener, "Sending notification to fixer: " + target.toString());
                    this.sendNotification(message, target, buildListener);
                }
                catch (Throwable e) {
                    this.log(buildListener, "There was an error sending fixer notification to: " + target.toString());
                }
            }
        }
        return true;
    }

    private void sendNotification(String message, IMMessageTarget target, BuildListener buildListener) throws IMException {
        IMConnection imConnection = this.getIMConnection();
        if (imConnection instanceof DummyConnection) {
            this.log(buildListener, "[ERROR] not connected. Cannot send message to '" + target + "'");
        } else {
            this.getIMConnection().send(target, message);
        }
    }

    private void notifyUpstreamCommitters(AbstractBuild<?, ?> build, BuildListener buildListener) {
        boolean committerNotified = false;
        HashMap upstreamBuilds = build.getUpstreamBuilds();
        while (!committerNotified && !upstreamBuilds.isEmpty()) {
            HashMap currentLevel = upstreamBuilds;
            upstreamBuilds = new HashMap();
            for (Map.Entry entry : currentLevel.entrySet()) {
                AbstractBuild upstreamBuild = (AbstractBuild)((AbstractProject)entry.getKey()).getBuildByNumber(((Integer)entry.getValue()).intValue());
                if (upstreamBuild != null) {
                    if (!this.downstreamIsFirstInRangeTriggeredByUpstream(upstreamBuild, build)) continue;
                    Set committers = IMPublisher.getCommitters((AbstractBuild)upstreamBuild);
                    String message = this.getBuildToChatNotifier().upstreamCommitterMessage(this, build, buildListener, upstreamBuild);
                    for (IMMessageTarget target : this.calculateIMTargets(committers, buildListener)) {
                        try {
                            this.log(buildListener, "Sending notification to upstream committer: " + target.toString());
                            this.sendNotification(message, target, buildListener);
                            committerNotified = true;
                        }
                        catch (Throwable e) {
                            this.log(buildListener, "There was an error sending upstream committer notification to: " + target.toString());
                        }
                    }
                }
                if (committerNotified) continue;
                upstreamBuilds.putAll(upstreamBuild.getUpstreamBuilds());
            }
        }
    }

    private boolean downstreamIsFirstInRangeTriggeredByUpstream(AbstractBuild<?, ?> upstreamBuild, AbstractBuild<?, ?> downstreamBuild) {
        Fingerprint.RangeSet rangeSet = upstreamBuild.getDownstreamRelationship(downstreamBuild.getProject());
        if (rangeSet.isEmpty()) {
            LOGGER.warning("Range set is empty. Upstream " + upstreamBuild + ", downstream " + downstreamBuild);
            return false;
        }
        return rangeSet.min() == downstreamBuild.getNumber();
    }

    private void notifyChats(AbstractBuild<?, ?> build, BuildListener buildListener) throws IOException, InterruptedException {
        String msg = this.buildToChatNotifier.buildCompletionMessage(this, build, buildListener);
        for (IMMessageTarget target : this.calculateTargets()) {
            try {
                this.log(buildListener, "Sending notification to: " + target.toString());
                this.sendNotification(msg, target, buildListener);
            }
            catch (Throwable t) {
                this.log(buildListener, "There was an error sending notification to: " + target.toString() + "\n" + ExceptionHelper.dump((Throwable)t));
            }
        }
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener buildListener) {
        try {
            if (this.notifyOnBuildStart) {
                String msg = this.buildToChatNotifier.buildStartMessage(this, build, buildListener);
                for (IMMessageTarget target : this.calculateTargets()) {
                    if (!(target instanceof GroupChatIMMessageTarget)) continue;
                    try {
                        this.sendNotification(msg, target, buildListener);
                    }
                    catch (Throwable e) {
                        this.log(buildListener, "There was an error sending notification to: " + target.toString());
                    }
                }
            }
        }
        catch (Throwable t) {
            this.log(buildListener, "There was an error in the IM plugin: " + ExceptionHelper.dump((Throwable)t));
        }
        return true;
    }

    private static Set<User> getCommitters(AbstractBuild<?, ?> build) {
        HashSet<User> committers = new HashSet<User>();
        ChangeLogSet changeSet = build.getChangeSet();
        for (ChangeLogSet.Entry entry : changeSet) {
            committers.add(entry.getAuthor());
        }
        return committers;
    }

    private static Set<User> getCulpritsOnly(AbstractBuild<?, ?> build) {
        HashSet<User> culprits = new HashSet<User>(build.getCulprits());
        culprits.removeAll(IMPublisher.getCommitters(build));
        return culprits;
    }

    private Collection<IMMessageTarget> calculateIMTargets(Set<User> targets, BuildListener listener) {
        HashSet<IMMessageTarget> suspects = new HashSet<IMMessageTarget>();
        String defaultIdSuffix = ((IMPublisherDescriptor)this.getDescriptor()).getDefaultIdSuffix();
        LOGGER.fine("Default Suffix: " + defaultIdSuffix);
        for (User target : targets) {
            LOGGER.fine("Possible target: " + target.getId());
            String imId = this.getConfiguredIMId(target);
            if (imId == null && defaultIdSuffix != null) {
                imId = target.getId() + defaultIdSuffix;
            }
            if (imId != null) {
                try {
                    suspects.add(this.getIMDescriptor().getIMMessageTargetConverter().fromString(imId));
                }
                catch (IMMessageTargetConversionException e) {
                    this.log(listener, "Invalid IM ID: " + imId);
                }
                continue;
            }
            this.log(listener, "No IM ID found for: " + target.getId());
        }
        return suspects;
    }

    public abstract BuildStepDescriptor<Publisher> getDescriptor();

    protected Object readResolve() {
        if (this.strategy == null && this.notificationStrategy != null) {
            this.strategy = NotificationStrategy.valueOf((String)this.notificationStrategy.name());
            this.notificationStrategy = null;
        }
        if (this.buildToChatNotifier == null) {
            this.buildToChatNotifier = new DefaultBuildToChatNotifier();
        }
        return this;
    }

    protected final IMPublisherDescriptor getIMDescriptor() {
        return (IMPublisherDescriptor)this.getDescriptor();
    }

    protected abstract String getConfiguredIMId(User var1);
}

