/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.build_notify;

import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.plugins.im.IMPublisher;
import hudson.plugins.im.build_notify.DefaultBuildToChatNotifier;
import hudson.plugins.im.tools.MessageHelper;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.TestObject;
import hudson.tasks.test.AbstractTestResultAction;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintFailingTestsBuildToChatNotifier
extends DefaultBuildToChatNotifier {
    @DataBoundConstructor
    public PrintFailingTestsBuildToChatNotifier() {
    }

    public String buildCompletionMessage(IMPublisher publisher, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        String msg = super.buildCompletionMessage(publisher, build, listener);
        return msg + this.getFailedTestsReport(build);
    }

    public String culpritMessage(IMPublisher publisher, AbstractBuild<?, ?> build, BuildListener listener) {
        String msg = super.culpritMessage(publisher, build, listener);
        return msg + this.getFailedTestsReport(build);
    }

    public String suspectMessage(IMPublisher publisher, AbstractBuild<?, ?> build, BuildListener listener, boolean firstFailure) {
        String msg = super.suspectMessage(publisher, build, listener, firstFailure);
        return msg + this.getFailedTestsReport(build);
    }

    public String upstreamCommitterMessage(IMPublisher publisher, AbstractBuild<?, ?> build, BuildListener listener, AbstractBuild<?, ?> upstreamBuild) {
        String msg = super.upstreamCommitterMessage(publisher, build, listener, upstreamBuild);
        return msg + this.getFailedTestsReport(build);
    }

    private CharSequence getFailedTestsReport(AbstractBuild<?, ?> build) {
        AbstractTestResultAction testResultAction = build.getTestResultAction();
        if (testResultAction == null || testResultAction.getFailCount() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        List failedTests = testResultAction.getFailedTests();
        Collections.sort(failedTests, new /* Unavailable Anonymous Inner Class!! */);
        int maxNumberOfTestsToPrint = 5;
        buf.append("\nFailed tests:\n");
        for (int i = 0; i < Math.min(5, failedTests.size()); ++i) {
            CaseResult test = (CaseResult)failedTests.get(i);
            buf.append(test.getFullName()).append(": ").append(MessageHelper.getTestUrl((TestObject)test)).append("\n");
        }
        int more = failedTests.size() - 5;
        if (more > 0) {
            buf.append("(").append(more).append(" more)");
        }
        return buf;
    }
}

