/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.bot;

import hudson.model.Hudson;
import hudson.model.Queue;
import hudson.plugins.im.IMChat;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessage;
import hudson.plugins.im.Sender;
import hudson.plugins.im.bot.Bot;
import hudson.plugins.im.bot.BotCommand;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueCommand
extends BotCommand {
    private static final String HELP = " - show the state of the build queue";

    @Override
    public Collection<String> getCommandNames() {
        return Arrays.asList("queue", "q");
    }

    @Override
    public void executeCommand(Bot bot, IMChat chat, IMMessage message, Sender sender, String[] args) throws IMException {
        String reply;
        Queue queue = Hudson.getInstance().getQueue();
        Queue.Item[] items = queue.getItems();
        if (items.length > 0) {
            StringBuffer msg = new StringBuffer();
            msg.append("Build queue:");
            for (Queue.Item item : queue.getItems()) {
                msg.append("\n- ").append(item.task.getFullDisplayName()).append(": ").append(item.getWhy());
            }
            reply = msg.toString();
        } else {
            reply = "build queue is empty";
        }
        chat.sendMessage(reply);
    }

    @Override
    public String getHelp() {
        return HELP;
    }
}

