/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.build_notify;

import hudson.DescriptorExtensionList;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Describable;
import hudson.model.Hudson;
import hudson.plugins.im.IMPublisher;
import hudson.plugins.im.build_notify.BuildToChatNotifierDescriptor;
import hudson.plugins.im.tools.BuildHelper;
import hudson.plugins.im.tools.MessageHelper;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BuildToChatNotifier
implements Describable<BuildToChatNotifier> {
    public abstract String buildStartMessage(IMPublisher var1, AbstractBuild<?, ?> var2, BuildListener var3) throws IOException, InterruptedException;

    public abstract String buildCompletionMessage(IMPublisher var1, AbstractBuild<?, ?> var2, BuildListener var3) throws IOException, InterruptedException;

    public String suspectMessage(IMPublisher publisher, AbstractBuild<?, ?> build, BuildListener listener, boolean firstFailure) {
        if (firstFailure) {
            return "Oh no! You're suspected of having broken " + BuildHelper.getProjectName(build) + ": " + MessageHelper.getBuildURL(build);
        }
        return "Build " + BuildHelper.getProjectName(build) + " is " + BuildHelper.getResultDescription(build) + ": " + MessageHelper.getBuildURL(build);
    }

    public String culpritMessage(IMPublisher publisher, AbstractBuild<?, ?> build, BuildListener listener) {
        return "You're still being suspected of having broken " + BuildHelper.getProjectName(build) + ": " + MessageHelper.getBuildURL(build);
    }

    public String fixerMessage(IMPublisher publisher, AbstractBuild<?, ?> build, BuildListener listener) {
        return "Yippie! Seems you've fixed " + BuildHelper.getProjectName(build) + ": " + MessageHelper.getBuildURL(build);
    }

    public String upstreamCommitterMessage(IMPublisher publisher, AbstractBuild<?, ?> build, BuildListener listener, AbstractBuild<?, ?> upstreamBuild) {
        return "Attention! Your change in " + BuildHelper.getProjectName(upstreamBuild) + ": " + MessageHelper.getBuildURL(upstreamBuild) + " *might* have broken the downstream job " + BuildHelper.getProjectName(build) + ": " + MessageHelper.getBuildURL(build) + "\nPlease have a look!";
    }

    public BuildToChatNotifierDescriptor getDescriptor() {
        return (BuildToChatNotifierDescriptor)Hudson.getInstance().getDescriptorOrDie(this.getClass());
    }

    public static DescriptorExtensionList<BuildToChatNotifier, BuildToChatNotifierDescriptor> all() {
        return Hudson.getInstance().getDescriptorList(BuildToChatNotifier.class);
    }
}

