/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im;

import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Hudson;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.im.IMConnection;
import hudson.plugins.im.IMConnectionProvider;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMPresence;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class HudsonIsBusyListener
extends RunListener {
    private static final Logger LOGGER = Logger.getLogger(HudsonIsBusyListener.class.getName());
    private static HudsonIsBusyListener INSTANCE;
    private final transient List<IMConnectionProvider> connectionProviders = new ArrayList();
    private final transient ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private transient int lastBusyExecutors = -1;
    private transient int lastTotalExecutors = -1;
    private final Runnable updateRunner = new /* Unavailable Anonymous Inner Class!! */;

    public static synchronized HudsonIsBusyListener getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HudsonIsBusyListener();
            INSTANCE.register();
        }
        return INSTANCE;
    }

    private HudsonIsBusyListener() {
        super(Run.class);
        this.executor.scheduleAtFixedRate(this.updateRunner, 10L, 60L, TimeUnit.SECONDS);
        LOGGER.info("Executor busy listener created");
    }

    public synchronized void addConnectionProvider(IMConnectionProvider provider) {
        this.connectionProviders.add(provider);
        LOGGER.fine("Added connection provider: " + provider);
    }

    public synchronized void removeConnectionProvider(IMConnectionProvider provider) {
        this.connectionProviders.remove(provider);
        LOGGER.fine("Removed connection provider: " + provider);
        if (this.connectionProviders.isEmpty()) {
            LOGGER.info("Last connection provider removed. Unregistering this instance.");
            this.unregister();
            INSTANCE = null;
        }
    }

    public void onCompleted(Run r, TaskListener listener) {
        this.updateLater();
    }

    public void onDeleted(Run r) {
        this.updateLater();
    }

    public void onStarted(Run r, TaskListener listener) {
        this.updateLater();
    }

    private void updateLater() {
        this.executor.schedule((Runnable)new /* Unavailable Anonymous Inner Class!! */, 1L, TimeUnit.SECONDS);
    }

    private synchronized void updateIMStatus() {
        int totalExecutors = this.getTotalExecutors();
        int busyExecutors = this.getBusyExecutors();
        if (totalExecutors != this.lastTotalExecutors || busyExecutors != this.lastBusyExecutors) {
            for (IMConnectionProvider provider : this.connectionProviders) {
                this.setStatus(provider, busyExecutors, totalExecutors);
            }
        }
        this.lastTotalExecutors = totalExecutors;
        this.lastBusyExecutors = busyExecutors;
    }

    private void setStatus(IMConnectionProvider provider, int busyExecutors, int totalExecutors) {
        try {
            IMConnection conn = provider.currentConnection();
            if (busyExecutors == 0) {
                conn.setPresence(IMPresence.AVAILABLE, "Yawn, I'm so bored. Don't you have some work for me?");
            } else if (busyExecutors == totalExecutors) {
                conn.setPresence(IMPresence.DND, "Please give me some rest! All " + totalExecutors + " executors are busy, " + Hudson.getInstance().getQueue().getItems().length + " job(s) in queue.");
            } else {
                String msg = "Working: " + busyExecutors + " out of " + totalExecutors + " executors are busy.";
                int queueItems = Hudson.getInstance().getQueue().getItems().length;
                if (queueItems > 0) {
                    msg = msg + " " + queueItems + " job(s) in queue.";
                }
                conn.setPresence(IMPresence.OCCUPIED, msg);
            }
        }
        catch (IMException e) {
            // empty catch block
        }
    }

    private int getBusyExecutors() {
        Computer[] computers;
        int busyExecutors = 0;
        for (Computer compi : computers = Hudson.getInstance().getComputers()) {
            for (Executor executor : compi.getExecutors()) {
                if (!executor.isBusy()) continue;
                ++busyExecutors;
            }
        }
        return busyExecutors;
    }

    private int getTotalExecutors() {
        Computer[] computers;
        int totalExecutors = 0;
        for (Computer compi : computers = Hudson.getInstance().getComputers()) {
            if (!compi.isOnline()) continue;
            totalExecutors += compi.getNumExecutors();
        }
        return totalExecutors;
    }

    static /* synthetic */ void access$000(HudsonIsBusyListener x0) {
        x0.updateIMStatus();
    }
}

