/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.bot;

import hudson.plugins.im.Sender;
import hudson.plugins.im.bot.AbstractTextSendingCommand;
import hudson.plugins.im.bot.Bot;
import hudson.plugins.im.tools.MessageHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnackCommand
extends AbstractTextSendingCommand {
    private static final String HELP = " [<snack>] - om nom nom";
    private static final String[] THANKS = new String[]{"thanks a lot! om nom nom.", "you're so kind to me!", "yummy!", "great! yum yum."};
    private static final String[] THANKS_WITH_FOOD = new String[]{"I really like that %s", "how did you know that %s is my favorite food?", "I just love %s!", "I could eat %s all day long"};
    private final Random ran = new Random();

    @Override
    public Collection<String> getCommandNames() {
        return Collections.singleton("botsnack");
    }

    @Override
    protected String getReply(Bot bot, Sender sender, String[] args) {
        String snack = null;
        if (args.length > 1) {
            snack = StringUtils.join((Object[])MessageHelper.copyOfRange(args, 1, args.length), (String)" ");
        }
        StringBuilder msg = new StringBuilder(sender.getNickname()).append(": ");
        int index = this.ran.nextInt(THANKS.length);
        msg.append(THANKS[index]);
        if (snack != null) {
            msg.append(" ");
            index = this.ran.nextInt(THANKS_WITH_FOOD.length);
            msg.append(String.format(THANKS_WITH_FOOD[index], snack));
        }
        return msg.toString();
    }

    @Override
    public String getHelp() {
        return HELP;
    }
}

