/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.build_notify;

import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.im.IMPublisher;
import hudson.plugins.im.build_notify.BuildToChatNotifierDescriptor;
import hudson.plugins.im.build_notify.SummaryOnlyBuildToChatNotifier;
import hudson.plugins.im.tools.BuildHelper;
import hudson.scm.ChangeLogSet;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBuildToChatNotifier
extends SummaryOnlyBuildToChatNotifier {
    @DataBoundConstructor
    public DefaultBuildToChatNotifier() {
    }

    @Override
    public String buildStartMessage(IMPublisher publisher, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        StringBuilder sb = new StringBuilder(super.buildStartMessage(publisher, build, listener));
        if (build.getPreviousBuild() != null) {
            AbstractBuild<?, ?> lastSuccessfulBuild;
            sb.append(" (previous build: ").append(BuildHelper.getResultDescription((AbstractBuild)build.getPreviousBuild()));
            if (((AbstractBuild)build.getPreviousBuild()).getResult().isWorseThan(Result.SUCCESS) && (lastSuccessfulBuild = BuildHelper.getPreviousSuccessfulBuild(build)) != null) {
                sb.append(" -- last ").append(Result.SUCCESS).append(" #").append(lastSuccessfulBuild.getNumber()).append(" ").append(lastSuccessfulBuild.getTimestampString()).append(" ago");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public String buildCompletionMessage(IMPublisher publisher, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        StringBuilder sb = new StringBuilder(super.buildCompletionMessage(publisher, build, listener));
        if (!build.getChangeSet().isEmptySet()) {
            boolean hasManyChangeSets = build.getChangeSet().getItems().length > 1;
            for (ChangeLogSet.Entry entry : build.getChangeSet()) {
                sb.append("\n");
                if (hasManyChangeSets) {
                    sb.append("* ");
                }
                sb.append(entry.getAuthor()).append(": ").append(entry.getMsg());
            }
        }
        return sb.toString();
    }

    public static class DescriptorImpl
    extends BuildToChatNotifierDescriptor {
        public String getDisplayName() {
            return "Summary + SCM changes";
        }
    }
}

