/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.bot;

import hudson.model.AbstractProject;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.plugins.im.Sender;
import hudson.plugins.im.bot.AbstractMultipleJobCommand;
import hudson.plugins.im.bot.AbstractTextSendingCommand;
import hudson.plugins.im.bot.Bot;
import hudson.plugins.im.bot.CommandException;
import hudson.plugins.im.tools.MessageHelper;
import hudson.plugins.im.tools.Pair;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractMultipleJobCommand
extends AbstractTextSendingCommand {
    static final String UNKNOWN_JOB_STR = "unknown job";
    static final String UNKNOWN_VIEW_STR = "unknown view";

    AbstractMultipleJobCommand() {
    }

    protected abstract CharSequence getMessageForJob(AbstractProject<?, ?> var1);

    protected abstract String getCommandShortName();

    protected String getReply(Bot bot, Sender sender, String[] args) {
        Pair pair;
        ArrayList projects = new ArrayList();
        try {
            pair = this.getProjects(sender, args, projects);
        }
        catch (CommandException e) {
            return this.getErrorReply(sender, e);
        }
        if (!projects.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            switch (1.$SwitchMap$hudson$plugins$im$bot$AbstractMultipleJobCommand$Mode[((Mode)pair.getHead()).ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    msg.append(this.getCommandShortName()).append(" of all projects:\n");
                    break;
                }
                case 3: {
                    msg.append(this.getCommandShortName()).append(" of projects in view " + (String)pair.getTail() + ":\n");
                }
            }
            boolean first = true;
            for (AbstractProject project : projects) {
                if (!first) {
                    msg.append("\n");
                } else {
                    first = false;
                }
                msg.append(this.getMessageForJob(project));
            }
            return msg.toString();
        }
        return sender + ": no job found";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Pair<Mode, String> getProjects(Sender sender, String[] args, Collection<AbstractProject<?, ?>> projects) throws CommandException {
        Mode mode;
        String view = null;
        if (args.length >= 2) {
            if ("-v".equals(args[1])) {
                mode = Mode.VIEW;
                view = MessageHelper.getJoinedName((String[])args, (int)2);
                this.getProjectsForView(projects, view);
                return Pair.create((Object)mode, (Object)view);
            } else {
                mode = Mode.SINGLE;
                String jobName = MessageHelper.getJoinedName((String[])args, (int)1);
                AbstractProject project = this.getJobProvider().getJobByName(jobName);
                if (project == null) throw new CommandException(sender.getNickname() + ": " + UNKNOWN_JOB_STR + " " + jobName);
                projects.add(project);
            }
            return Pair.create((Object)mode, (Object)view);
        } else {
            if (args.length != 1) throw new CommandException(sender + ": 'args' must not be empty!");
            mode = Mode.ALL;
            for (AbstractProject project : this.getJobProvider().getAllJobs()) {
                if (!this.getJobProvider().isTopLevelJob(project)) continue;
                projects.add(project);
            }
        }
        return Pair.create((Object)mode, (Object)view);
    }

    public String getHelp() {
        return " [<job>|-v <view>] - show the " + this.getCommandShortName() + " of a specific job, jobs in a view or all jobs";
    }

    private void getProjectsForView(Collection<AbstractProject<?, ?>> toAddTo, String viewName) {
        View view = this.getJobProvider().getView(viewName);
        if (view != null) {
            Collection items = view.getItems();
            for (TopLevelItem item : items) {
                if (!(item instanceof AbstractProject)) continue;
                toAddTo.add((AbstractProject)item);
            }
        } else {
            throw new IllegalArgumentException("unknown view: " + viewName);
        }
    }
}

