/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.bot;

import hudson.Extension;
import hudson.plugins.im.Sender;
import hudson.plugins.im.bot.AbstractTextSendingCommand;
import hudson.plugins.im.bot.Bot;
import hudson.plugins.im.bot.BotCommand;
import hudson.plugins.im.bot.SetAliasCommand;
import hudson.plugins.im.tools.MessageHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.lang.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class SetAliasCommand
extends AbstractTextSendingCommand {
    public Collection<String> getCommandNames() {
        return Collections.singleton("alias");
    }

    protected String getReply(Bot bot, Sender sender, String[] args) {
        if (args.length < 1) {
            throw new IllegalArgumentException();
        }
        if (args.length == 1) {
            SortedMap aliases = bot.getAliases();
            if (aliases.isEmpty()) {
                return "Defined aliases: none";
            }
            StringBuilder msg = new StringBuilder("Defined aliases:");
            for (Map.Entry entry : aliases.entrySet()) {
                msg.append("\n\t").append((String)entry.getKey()).append(((AliasCommand)entry.getValue()).getHelp());
            }
            return msg.toString();
        }
        if (args.length < 3) {
            String alias = args[1];
            AliasCommand aliasCmd = bot.removeAlias(alias);
            if (aliasCmd != null) {
                return "deleted alias: " + alias + aliasCmd.getHelp();
            }
            return sender.getNickname() + ": don't know an alias called '" + alias + "'";
        }
        String alias = args[1];
        String cmdName = args[2];
        BotCommand cmd = bot.getCommand(cmdName);
        if (cmd == null) {
            return sender.getNickname() + ": sorry don't know a command or alias called '" + cmdName + "'";
        }
        String[] cmdArguments = ArrayUtils.EMPTY_STRING_ARRAY;
        if (args.length > 3) {
            cmdArguments = (String[])MessageHelper.copyOfRange((Object[])args, (int)3, (int)args.length);
        }
        AliasCommand aliasCmd = new AliasCommand(cmd, cmdName, cmdArguments);
        try {
            bot.addAlias(alias, (BotCommand)aliasCmd);
        }
        catch (IllegalArgumentException e) {
            return sender.getNickname() + ": " + e.getMessage();
        }
        return "created alias: " + alias + aliasCmd.getHelp();
    }

    public String getHelp() {
        return " [<alias> [<command>]] - defines a new alias, deletes one or lists all existing aliases";
    }
}

