/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.bot;

import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.User;
import hudson.plugins.cigame.UserScoreProperty;
import hudson.plugins.im.Sender;
import hudson.plugins.im.bot.AbstractTextSendingCommand;
import hudson.plugins.im.bot.Bot;
import hudson.tasks.Mailer;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class UserStatCommand
extends AbstractTextSendingCommand {
    public Collection<String> getCommandNames() {
        return Collections.singleton("userstat");
    }

    protected String getReply(Bot bot, Sender sender, String[] args) {
        String userName = args[1];
        User user = User.get((String)userName, (boolean)false);
        if (user != null) {
            UserScoreProperty property;
            Mailer.UserProperty mailProperty;
            StringBuilder buf = new StringBuilder();
            buf.append(userName).append(":");
            if (!userName.equals(user.getFullName())) {
                buf.append("\n").append("Full name: ").append(user.getFullName());
            }
            if (user.getDescription() != null) {
                buf.append("\n").append("Description: ").append(user.getDescription());
            }
            if ((mailProperty = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class)) != null) {
                buf.append("\n").append("E-mail: ").append(mailProperty.getAddress());
            }
            if (Hudson.getInstance().getPlugin("ci-game") != null && (property = (UserScoreProperty)user.getProperty(UserScoreProperty.class)) != null) {
                int score = (int)property.getScore();
                buf.append("\n").append("Current score in continuous integration game: ").append(score);
            }
            return buf.toString();
        }
        return "Don't know a user named " + userName;
    }

    public String getHelp() {
        return " <username> - prints information about a Hudson user";
    }
}

