/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im;

import hudson.model.Hudson;
import hudson.plugins.im.AuthenticationHolder;
import hudson.plugins.im.DummyConnection;
import hudson.plugins.im.IMConnection;
import hudson.plugins.im.IMConnectionListener;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMPublisherDescriptor;
import hudson.plugins.im.tools.ExceptionHelper;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.acegisecurity.Authentication;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;

public abstract class IMConnectionProvider
implements IMConnectionListener {
    private static final Logger LOGGER = Logger.getLogger(IMConnectionProvider.class.getName());
    private static final IMConnection NULL_CONNECTION = new DummyConnection();
    protected IMPublisherDescriptor descriptor;
    private IMConnection imConnection = NULL_CONNECTION;
    private Authentication authentication = null;
    private final ConnectorRunnable connector = new ConnectorRunnable();

    protected IMConnectionProvider() {
    }

    protected void init() {
        Thread connectorThread = new Thread((Runnable)this.connector, "IM-Reconnector-Thread");
        connectorThread.setDaemon(true);
        connectorThread.start();
        this.tryReconnect();
    }

    public abstract IMConnection createConnection() throws IMException;

    private synchronized boolean create() throws IMException {
        if (this.descriptor == null || !this.descriptor.isEnabled()) {
            this.imConnection = NULL_CONNECTION;
            return true;
        }
        try {
            this.imConnection = this.createConnection();
            this.imConnection.addConnectionListener(this);
            return true;
        }
        catch (IMException e) {
            this.imConnection = NULL_CONNECTION;
            this.tryReconnect();
            return false;
        }
    }

    public synchronized IMConnection currentConnection() {
        return this.imConnection;
    }

    public synchronized void releaseConnection() {
        if (this.imConnection != null) {
            this.imConnection.removeConnectionListener(this);
            this.imConnection.close();
            this.imConnection = NULL_CONNECTION;
        }
    }

    protected IMPublisherDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(IMPublisherDescriptor desc) {
        this.descriptor = desc;
        if (desc != null && desc.isEnabled()) {
            this.tryReconnect();
        }
    }

    public void connectionBroken(Exception e) {
        this.tryReconnect();
    }

    private void tryReconnect() {
        this.connector.semaphore.release();
    }

    public synchronized AuthenticationHolder getAuthenticationHolder() {
        if (this.descriptor == null || this.descriptor.getHudsonUserName() == null) {
            return null;
        }
        return new AuthenticationHolder(){

            public Authentication getAuthentication() {
                if (IMConnectionProvider.this.authentication != null) {
                    return IMConnectionProvider.this.authentication;
                }
                try {
                    UsernamePasswordAuthenticationToken tmp = new UsernamePasswordAuthenticationToken((Object)IMConnectionProvider.this.descriptor.getHudsonUserName(), (Object)IMConnectionProvider.this.descriptor.getHudsonPassword());
                    IMConnectionProvider.this.authentication = Hudson.getInstance().getSecurityRealm().getSecurityComponents().manager.authenticate((Authentication)tmp);
                }
                catch (Exception e) {
                    LOGGER.warning(IMConnectionProvider.this.descriptor.getPluginDescription() + " couldn't authenticate against Hudson: " + e);
                }
                return IMConnectionProvider.this.authentication;
            }
        };
    }

    private final class ConnectorRunnable
    implements Runnable {
        private final Semaphore semaphore = new Semaphore(0);
        private boolean firstConnect = true;

        private ConnectorRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                block9: while (true) {
                    this.semaphore.acquire();
                    if (!this.firstConnect) {
                        TimeUnit.SECONDS.sleep(30L);
                        LOGGER.info("Trying to reconnect");
                    } else {
                        this.firstConnect = false;
                        LOGGER.info("Trying to connect");
                    }
                    boolean success = false;
                    int timeout = 1;
                    while (true) {
                        if (success) continue block9;
                        IMConnectionProvider iMConnectionProvider = IMConnectionProvider.this;
                        synchronized (iMConnectionProvider) {
                            if (IMConnectionProvider.this.imConnection != null) {
                                try {
                                    IMConnectionProvider.this.releaseConnection();
                                }
                                catch (Exception e) {
                                    LOGGER.warning(ExceptionHelper.dump(e));
                                }
                            }
                            try {
                                success = IMConnectionProvider.this.create();
                            }
                            catch (IMException e) {
                                // empty catch block
                            }
                        }
                        if (!success) {
                            LOGGER.info("Reconnect failed. Next connection attempt in " + timeout + " minutes");
                            this.semaphore.drainPermits();
                            this.semaphore.tryAcquire(timeout * 60, TimeUnit.SECONDS);
                            if (timeout >= 15) continue;
                            timeout *= 2;
                            continue;
                        }
                        this.semaphore.drainPermits();
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                LOGGER.info("Connect thread interrupted");
                return;
            }
        }
    }
}

