/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.bot;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Executor;
import hudson.model.Hudson;
import hudson.plugins.im.Sender;
import hudson.plugins.im.bot.AbstractSingleJobCommand;
import hudson.plugins.im.bot.CommandException;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class AbortCommand
extends AbstractSingleJobCommand {
    private static final String HELP = " <job> - specify which job to abort";

    @Override
    public Collection<String> getCommandNames() {
        return Collections.singleton("abort");
    }

    @Override
    public String getHelp() {
        return HELP;
    }

    @Override
    protected CharSequence getMessageForJob(AbstractProject<?, ?> project, Sender sender, String[] args) throws CommandException {
        if (!project.isInQueue() && !project.isBuilding()) {
            throw new CommandException(sender + ": how do you intend to abort a build that isn't building?");
        }
        boolean aborted = false;
        if (project.isInQueue()) {
            aborted = Hudson.getInstance().getQueue().cancel(project);
        }
        if (!aborted) {
            AbstractBuild build = (AbstractBuild)project.getLastBuild();
            if (build == null) {
                throw new CommandException(sender.getNickname() + ": it appears this job has never been built");
            }
            Executor ex = build.getExecutor();
            if (ex == null) {
                aborted = false;
            } else {
                ex.interrupt();
            }
        }
        if (aborted) {
            return project.getFullDisplayName() + " aborted, I hope you're happy!";
        }
        throw new CommandException(sender.getNickname() + ": " + " couldn't abort " + project.getFullDisplayName() + ". I don't know why this happened.");
    }
}

