/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.bot;

import hudson.plugins.im.IMChat;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessage;
import hudson.plugins.im.Sender;
import hudson.plugins.im.bot.Bot;
import hudson.plugins.im.bot.BotCommand;
import hudson.plugins.im.bot.CommandException;
import hudson.plugins.im.bot.DefaultJobProvider;
import hudson.plugins.im.bot.JobProvider;
import hudson.plugins.im.tools.ExceptionHelper;
import java.util.logging.Logger;

public abstract class AbstractTextSendingCommand
extends BotCommand {
    private static final Logger LOGGER = Logger.getLogger(AbstractTextSendingCommand.class.getName());
    private JobProvider jobProvider = new DefaultJobProvider();

    protected JobProvider getJobProvider() {
        return this.jobProvider;
    }

    void setJobProvider(JobProvider jobProvider) {
        this.jobProvider = jobProvider;
    }

    public final void executeCommand(Bot bot, IMChat chat, IMMessage message, Sender sender, String[] args) throws IMException {
        String reply;
        try {
            reply = this.getReply(bot, sender, args);
        }
        catch (RuntimeException e) {
            LOGGER.warning(ExceptionHelper.dump(e));
            reply = sender.getNickname() + ": Error " + e.toString();
        }
        chat.sendMessage(reply);
    }

    protected abstract String getReply(Bot var1, Sender var2, String[] var3);

    protected String getErrorReply(Sender sender, CommandException e) {
        StringBuilder reply = e.getReplyMessage() != null ? new StringBuilder(e.getReplyMessage()).append("\n") : new StringBuilder(sender.getNickname()).append(": command couldn't be executed. Error:\n");
        if (e.getCause() != null) {
            reply.append("Cause: ").append(ExceptionHelper.dump(e.getCause()));
        }
        return reply.toString();
    }
}

