/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.bot;

import hudson.plugins.im.IMChat;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessage;
import hudson.plugins.im.bot.BotCommand;
import hudson.plugins.im.bot.CommandException;
import hudson.plugins.im.tools.ExceptionHelper;
import java.util.logging.Logger;

public abstract class AbstractTextSendingCommand
implements BotCommand {
    private static final Logger LOGGER = Logger.getLogger(AbstractTextSendingCommand.class.getName());

    public final void executeCommand(IMChat chat, IMMessage message, String sender, String[] args) throws IMException {
        String reply;
        try {
            reply = this.getReply(sender, args);
        }
        catch (RuntimeException e) {
            LOGGER.warning(e.toString());
            reply = sender + ": Error " + e.toString();
        }
        chat.sendMessage(reply);
    }

    protected abstract String getReply(String var1, String[] var2);

    protected String getErrorReply(String sender, CommandException e) {
        StringBuilder reply = e.getReplyMessage() != null ? new StringBuilder(e.getReplyMessage()).append("\n") : new StringBuilder(sender).append(": command couldn't be executed. Error:\n");
        if (e.getCause() != null) {
            reply.append("Cause: ").append(ExceptionHelper.dump((Throwable)e.getCause()));
        }
        return reply.toString();
    }
}

