/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im;

import hudson.model.Hudson;
import hudson.plugins.im.DummyConnection;
import hudson.plugins.im.IMConnection;
import hudson.plugins.im.IMConnectionListener;
import hudson.plugins.im.IMConnectionProvider;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMPublisherDescriptor;
import java.util.logging.Logger;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class IMConnectionProvider
implements IMConnectionListener {
    private static final Logger LOGGER = Logger.getLogger(IMConnectionProvider.class.getName());
    private static final IMConnection NULL_CONNECTION = new DummyConnection();
    protected IMPublisherDescriptor descriptor;
    private IMConnection imConnection;
    private Authentication authentication = null;
    private final ConnectorRunnable connector = new ConnectorRunnable(this, null);

    protected IMConnectionProvider() {
        Thread connectorThread = new Thread((Runnable)this.connector, "IM-Reconnector-Thread");
        connectorThread.setDaemon(true);
        connectorThread.start();
    }

    public abstract IMConnection createConnection() throws IMException;

    public synchronized IMConnection currentConnection() {
        if (this.imConnection == null) {
            try {
                this.imConnection = this.createConnection();
            }
            catch (IMException e) {
                this.tryReconnect();
                return NULL_CONNECTION;
            }
            if (this.imConnection != null) {
                this.imConnection.addConnectionListener((IMConnectionListener)this);
                return this.imConnection;
            }
            if (this.descriptor != null) {
                this.tryReconnect();
            }
            return NULL_CONNECTION;
        }
        return this.imConnection;
    }

    public synchronized void releaseConnection() {
        if (this.imConnection != null) {
            this.imConnection.removeConnectionListener((IMConnectionListener)this);
            this.imConnection.close();
            this.imConnection = null;
        }
    }

    protected IMPublisherDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(IMPublisherDescriptor desc) {
        this.descriptor = desc;
        if (desc != null && desc.getHudsonUserName() != null) {
            try {
                UsernamePasswordAuthenticationToken tmp = new UsernamePasswordAuthenticationToken((Object)desc.getHudsonUserName(), (Object)desc.getHudsonPassword());
                this.authentication = Hudson.getInstance().getSecurityRealm().getSecurityComponents().manager.authenticate((Authentication)tmp);
            }
            catch (AuthenticationException e) {
                LOGGER.warning(this.descriptor.getPluginDescription() + " couldn't authenticate against Hudson: " + (Object)((Object)e));
            }
        }
    }

    public void connectionBroken(Exception e) {
        this.tryReconnect();
    }

    private void tryReconnect() {
        ConnectorRunnable.access$100((ConnectorRunnable)this.connector).release();
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }

    static /* synthetic */ IMConnection access$300(IMConnectionProvider x0) {
        return x0.imConnection;
    }

    static /* synthetic */ IMConnection access$302(IMConnectionProvider x0, IMConnection x1) {
        x0.imConnection = x1;
        return x0.imConnection;
    }
}

