/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.User;
import hudson.plugins.im.DefaultIMMessageTargetConverter;
import hudson.plugins.im.GroupChatIMMessageTarget;
import hudson.plugins.im.IMConnection;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessageTarget;
import hudson.plugins.im.IMMessageTargetConversionException;
import hudson.plugins.im.IMMessageTargetConverter;
import hudson.plugins.im.IMPublisherDescriptor;
import hudson.plugins.im.NotificationStrategy;
import hudson.plugins.im.tools.Assert;
import hudson.plugins.im.tools.BuildHelper;
import hudson.plugins.im.tools.ExceptionHelper;
import hudson.plugins.im.tools.MessageHelper;
import hudson.scm.ChangeLogSet;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IMPublisher
extends Notifier
implements BuildStep {
    private static final Logger LOGGER = Logger.getLogger(IMPublisher.class.getName());
    private static final IMMessageTargetConverter CONVERTER = new DefaultIMMessageTargetConverter();
    private List<IMMessageTarget> targets = new LinkedList<IMMessageTarget>();
    @Deprecated
    private hudson.plugins.jabber.NotificationStrategy notificationStrategy;
    private NotificationStrategy strategy;
    private final boolean notifyOnBuildStart;
    private final boolean notifySuspects;
    private final boolean notifyCulprits;
    private final boolean notifyFixers;
    private final boolean notifyUpstreamCommitters;
    @Deprecated
    private transient String defaultIdSuffix;

    protected IMPublisher(String targetsAsString, String notificationStrategyString, boolean notifyGroupChatsOnBuildStart, boolean notifySuspects, boolean notifyCulprits, boolean notifyFixers, boolean notifyUpstreamCommitters) throws IMMessageTargetConversionException {
        Assert.isNotNull(targetsAsString, "Parameter 'targetsAsString' must not be null.");
        this.setTargets(targetsAsString);
        NotificationStrategy strategy = NotificationStrategy.forDisplayName(notificationStrategyString);
        if (strategy == null) {
            strategy = NotificationStrategy.STATECHANGE_ONLY;
        }
        this.strategy = strategy;
        this.notifyOnBuildStart = notifyGroupChatsOnBuildStart;
        this.notifySuspects = notifySuspects;
        this.notifyCulprits = notifyCulprits;
        this.notifyFixers = notifyFixers;
        this.notifyUpstreamCommitters = notifyUpstreamCommitters;
    }

    public boolean needsToRunAfterFinalized() {
        return this.notifyUpstreamCommitters;
    }

    protected abstract String getPluginName();

    protected abstract IMConnection getIMConnection() throws IMException;

    protected IMMessageTargetConverter getIMMessageTargetConverter() {
        return CONVERTER;
    }

    protected NotificationStrategy getNotificationStrategy() {
        return this.strategy;
    }

    protected void setNotificationStrategy(NotificationStrategy strategy) {
        this.strategy = strategy;
    }

    protected List<IMMessageTarget> getNotificationTargets() {
        return this.targets;
    }

    public String getTargets() {
        if (this.targets == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (IMMessageTarget t : this.targets) {
            sb.append(this.getIMMessageTargetConverter().toString(t));
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    protected void setTargets(String targetsAsString) throws IMMessageTargetConversionException {
        this.targets = new LinkedList<IMMessageTarget>();
        String[] split = targetsAsString.split("\\s");
        IMMessageTargetConverter conv = this.getIMMessageTargetConverter();
        for (String fragment : split) {
            IMMessageTarget createIMMessageTarget = conv.fromString(fragment);
            if (createIMMessageTarget == null) continue;
            this.targets.add(createIMMessageTarget);
        }
    }

    public final String getStrategy() {
        return this.getNotificationStrategy().getDisplayName();
    }

    public final boolean getNotifyOnStart() {
        return this.notifyOnBuildStart;
    }

    public final boolean getNotifySuspects() {
        return this.notifySuspects;
    }

    public final boolean getNotifyCulprits() {
        return this.notifyCulprits;
    }

    public final boolean getNotifyFixers() {
        return this.notifyFixers;
    }

    public final boolean getNotifyUpstreamCommitters() {
        return this.notifyUpstreamCommitters;
    }

    protected void log(BuildListener listener, String message) {
        listener.getLogger().append(this.getPluginName()).append(": ").append(message).append("\n");
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener buildListener) throws InterruptedException, IOException {
        Assert.isNotNull(build, "Parameter 'build' must not be null.");
        Assert.isNotNull(buildListener, "Parameter 'buildListener' must not be null.");
        if (this.getNotificationStrategy().notificationWanted(build)) {
            this.notifyChats(build, buildListener);
        }
        if (BuildHelper.isStillFailureOrUnstable(build)) {
            String message;
            if (this.notifySuspects) {
                this.log(buildListener, "Notifying suspects");
                message = "Build " + build.getProject().getName() + " is " + BuildHelper.getResultDescription(build) + ": " + MessageHelper.getBuildURL(build);
                for (IMMessageTarget target : this.calculateIMTargets(IMPublisher.getCommitters(build), buildListener)) {
                    try {
                        this.log(buildListener, "Sending notification to suspect: " + target.toString());
                        this.getIMConnection().send(target, message);
                    }
                    catch (Throwable e) {
                        this.log(buildListener, "There was an error sending suspect notification to: " + target.toString());
                    }
                }
            }
            if (this.notifyCulprits) {
                this.log(buildListener, "Notifying culprits");
                message = "You're still being suspected of having broken " + build.getProject().getName() + ": " + MessageHelper.getBuildURL(build);
                for (IMMessageTarget target : this.calculateIMTargets(IMPublisher.getCulpritsOnly(build), buildListener)) {
                    try {
                        this.log(buildListener, "Sending notification to culprit: " + target.toString());
                        this.getIMConnection().send(target, message);
                    }
                    catch (Throwable e) {
                        this.log(buildListener, "There was an error sending culprit notification to: " + target.toString());
                    }
                }
            }
        } else if (BuildHelper.isFailureOrUnstable(build)) {
            boolean committerNotified = false;
            if (this.notifySuspects) {
                this.log(buildListener, "Notifying suspects");
                String message = "Oh no! You're suspected of having broken " + build.getProject().getName() + ": " + MessageHelper.getBuildURL(build);
                for (IMMessageTarget target : this.calculateIMTargets(IMPublisher.getCommitters(build), buildListener)) {
                    try {
                        this.log(buildListener, "Sending notification to suspect: " + target.toString());
                        this.getIMConnection().send(target, message);
                        committerNotified = true;
                    }
                    catch (Throwable e) {
                        this.log(buildListener, "There was an error sending suspect notification to: " + target.toString());
                    }
                }
            }
            if (this.notifyUpstreamCommitters && !committerNotified) {
                this.notifyUpstreamCommitters(build, buildListener);
            }
        }
        if (this.notifyFixers && BuildHelper.isFix(build)) {
            buildListener.getLogger().append("Notifying fixers\n");
            String message = "Yippie! Seems you've fixed " + build.getProject().getName() + ": " + MessageHelper.getBuildURL(build);
            for (IMMessageTarget target : this.calculateIMTargets(IMPublisher.getCommitters(build), buildListener)) {
                try {
                    this.log(buildListener, "Sending notification to fixer: " + target.toString());
                    this.getIMConnection().send(target, message);
                }
                catch (Throwable e) {
                    this.log(buildListener, "There was an error sending fixer notification to: " + target.toString());
                }
            }
        }
        return true;
    }

    private void notifyUpstreamCommitters(AbstractBuild<?, ?> build, BuildListener buildListener) {
        boolean committerNotified = false;
        HashMap upstreamBuilds = build.getUpstreamBuilds();
        while (!committerNotified && !upstreamBuilds.isEmpty()) {
            HashMap currentLevel = upstreamBuilds;
            upstreamBuilds = new HashMap();
            for (Map.Entry entry : currentLevel.entrySet()) {
                AbstractBuild upstreamBuild = (AbstractBuild)((AbstractProject)entry.getKey()).getBuildByNumber(((Integer)entry.getValue()).intValue());
                Set<User> committers = IMPublisher.getCommitters(upstreamBuild);
                String message = "Attention! Your change in " + upstreamBuild.getProject().getName() + ": " + MessageHelper.getBuildURL(upstreamBuild) + " *might* have broken the downstream job " + build.getProject().getName() + ": " + MessageHelper.getBuildURL(build) + "\nPlease have a look!";
                for (IMMessageTarget target : this.calculateIMTargets(committers, buildListener)) {
                    try {
                        this.log(buildListener, "Sending notification to upstream committer: " + target.toString());
                        this.getIMConnection().send(target, message);
                        committerNotified = true;
                    }
                    catch (Throwable e) {
                        this.log(buildListener, "There was an error sending upstream committer notification to: " + target.toString());
                    }
                }
                if (committerNotified) continue;
                upstreamBuilds.putAll(upstreamBuild.getUpstreamBuilds());
            }
        }
    }

    private void notifyChats(AbstractBuild<?, ?> build, BuildListener buildListener) {
        StringBuilder sb = BuildHelper.isFix(build) ? new StringBuilder("Yippie, build fixed!\n") : new StringBuilder();
        sb.append("Project ").append(build.getProject().getName()).append(" build (").append(build.getNumber()).append("): ").append(BuildHelper.getResultDescription(build)).append(" in ").append(build.getTimestampString()).append(": ").append(MessageHelper.getBuildURL(build));
        if (!build.getChangeSet().isEmptySet()) {
            boolean hasManyChangeSets = build.getChangeSet().getItems().length > 1;
            for (ChangeLogSet.Entry entry : build.getChangeSet()) {
                sb.append("\n");
                if (hasManyChangeSets) {
                    sb.append("* ");
                }
                sb.append(entry.getAuthor()).append(": ").append(entry.getMsg());
            }
        }
        String msg = sb.toString();
        for (IMMessageTarget target : this.getNotificationTargets()) {
            try {
                this.log(buildListener, "Sending notification to: " + target.toString());
                this.getIMConnection().send(target, msg);
            }
            catch (Throwable t) {
                this.log(buildListener, "There was an error sending notification to: " + target.toString() + "\n" + ExceptionHelper.dump(t));
            }
        }
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener buildListener) {
        try {
            if (this.notifyOnBuildStart) {
                StringBuilder sb = new StringBuilder("Starting build ").append(build.getNumber()).append(" for job ").append(build.getProject().getName());
                if (build.getPreviousBuild() != null) {
                    AbstractBuild lastSuccessfulBuild;
                    sb.append(" (previous build: ").append(BuildHelper.getResultDescription((AbstractBuild)build.getPreviousBuild()));
                    if (((AbstractBuild)build.getPreviousBuild()).getResult().isWorseThan(Result.SUCCESS) && (lastSuccessfulBuild = (AbstractBuild)build.getPreviousNotFailedBuild()) != null) {
                        sb.append(" -- last ").append(BuildHelper.getResultDescription(lastSuccessfulBuild)).append(" #").append(lastSuccessfulBuild.getNumber()).append(" ").append(lastSuccessfulBuild.getTimestampString()).append(" ago");
                    }
                    sb.append(")");
                }
                String msg = sb.toString();
                for (IMMessageTarget target : this.getNotificationTargets()) {
                    if (!(target instanceof GroupChatIMMessageTarget)) continue;
                    try {
                        this.getIMConnection().send(target, msg);
                    }
                    catch (Throwable e) {
                        this.log(buildListener, "There was an error sending notification to: " + target.toString());
                    }
                }
            }
        }
        catch (Throwable t) {
            this.log(buildListener, "There was an error in the IM plugin: " + ExceptionHelper.dump(t));
        }
        return true;
    }

    private static Set<User> getCommitters(AbstractBuild<?, ?> build) {
        HashSet<User> committers = new HashSet<User>();
        ChangeLogSet changeSet = build.getChangeSet();
        for (ChangeLogSet.Entry entry : changeSet) {
            committers.add(entry.getAuthor());
        }
        return committers;
    }

    private static Set<User> getCulpritsOnly(AbstractBuild<?, ?> build) {
        HashSet<User> culprits = new HashSet<User>(build.getCulprits());
        culprits.removeAll(IMPublisher.getCommitters(build));
        return culprits;
    }

    private Collection<IMMessageTarget> calculateIMTargets(Set<User> targets, BuildListener listener) {
        HashSet<IMMessageTarget> suspects = new HashSet<IMMessageTarget>();
        String defaultIdSuffix = ((IMPublisherDescriptor)this.getDescriptor()).getDefaultIdSuffix();
        LOGGER.fine("Default Suffix: " + defaultIdSuffix);
        for (User target : targets) {
            LOGGER.fine("Possible target: " + target.getId());
            String imId = this.getConfiguredIMId(target);
            if (imId == null && defaultIdSuffix != null) {
                imId = target.getId() + defaultIdSuffix;
            }
            if (imId != null) {
                try {
                    suspects.add(CONVERTER.fromString(imId));
                }
                catch (IMMessageTargetConversionException e) {
                    this.log(listener, "Invalid IM ID: " + imId);
                }
                continue;
            }
            this.log(listener, "No IM ID found for: " + target.getId());
        }
        return suspects;
    }

    public abstract BuildStepDescriptor<Publisher> getDescriptor();

    private Object readResolve() {
        if (this.strategy == null && this.notificationStrategy != null) {
            this.strategy = NotificationStrategy.valueOf(this.notificationStrategy.name());
            this.notificationStrategy = null;
        }
        return this;
    }

    protected abstract String getConfiguredIMId(User var1);
}

