/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.bot;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Executor;
import hudson.model.Hudson;
import hudson.plugins.im.bot.AbstractSingleJobCommand;
import hudson.plugins.im.bot.CommandException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbortCommand
extends AbstractSingleJobCommand {
    private static final String HELP = " <job> - specify which job to abort";

    @Override
    public String getHelp() {
        return HELP;
    }

    @Override
    protected CharSequence getMessageForJob(AbstractProject<?, ?> project, String sender, String[] args) throws CommandException {
        if (!project.isInQueue() && !project.isBuilding()) {
            throw new CommandException(sender + ": how do you intend to abort a build that isn't building?");
        }
        boolean aborted = false;
        if (project.isInQueue()) {
            aborted = Hudson.getInstance().getQueue().cancel(project);
        }
        if (!aborted) {
            AbstractBuild build = (AbstractBuild)project.getLastBuild();
            if (build == null) {
                throw new CommandException(sender + ": it appears this job has never been built");
            }
            Executor ex = build.getExecutor();
            if (ex == null) {
                aborted = false;
            } else {
                ex.interrupt();
            }
        }
        if (aborted) {
            return project.getName() + " aborted, I hope you're happy!";
        }
        throw new CommandException(sender + ": " + " couldn't abort " + project.getName() + ". I don't know why this happened.");
    }
}

