/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.bot;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.HealthReport;
import hudson.plugins.im.bot.AbstractMultipleJobCommand;
import hudson.plugins.im.tools.MessageHelper;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HealthCommand
extends AbstractMultipleJobCommand {
    @Override
    protected CharSequence getMessageForJob(AbstractProject<?, ?> project) {
        AbstractBuild lastBuild;
        StringBuilder msg = new StringBuilder(32);
        msg.append(project.getName());
        if (project.isDisabled()) {
            msg.append("(disabled)");
        } else if (project.isBuilding()) {
            msg.append("(BUILDING: ").append(((AbstractBuild)project.getLastBuild()).getDurationString()).append(")");
        } else if (project.isInQueue()) {
            msg.append("(in queue)");
        }
        msg.append(": ");
        for (lastBuild = (AbstractBuild)project.getLastBuild(); lastBuild != null && lastBuild.isBuilding(); lastBuild = (AbstractBuild)lastBuild.getPreviousBuild()) {
        }
        if (lastBuild != null) {
            msg.append("Health [");
            List<HealthReport> reports = project.getBuildHealthReports();
            if (reports.isEmpty()) {
                reports = Collections.singletonList(project.getBuildHealth());
            }
            int i = 1;
            for (HealthReport health : reports) {
                msg.append(health.getDescription()).append("(").append(health.getScore()).append("%)");
                if (i < reports.size()) {
                    msg.append(", ");
                }
                ++i;
            }
            msg.append(": ").append(MessageHelper.getBuildURL(lastBuild));
        } else {
            msg.append("no finished build yet");
        }
        return msg;
    }

    @Override
    protected String getCommandShortName() {
        return "health";
    }
}

