/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.mks.api.Command;
import com.mks.api.MultiValue;
import com.mks.api.Option;
import com.mks.api.response.APIException;
import com.mks.api.response.Response;
import com.mks.api.response.WorkItemIterator;
import com.mks.api.util.Base64;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.scm.APISession;
import hudson.scm.ExceptionHandler;
import hudson.scm.IntegrityItemAction;
import hudson.scm.IntegritySCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrityItemAction
extends Notifier {
    private String hostName;
    private int port;
    private boolean secure;
    private String userName;
    private String password;
    private String queryDefinition;
    private String stateField;
    private String successValue;
    private String failureValue;
    private String logField;
    private final Log logger = LogFactory.getLog(this.getClass());
    @Extension
    public static final IntegrityItemDescriptorImpl ITEM_DESCRIPTOR = new IntegrityItemDescriptorImpl();

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password != null && this.password.length() > 0 ? Base64.decode((String)this.password) : this.password;
    }

    public String getQueryDefinition() {
        return this.queryDefinition;
    }

    public String getStateField() {
        return this.stateField;
    }

    public String getSuccessValue() {
        return this.successValue;
    }

    public String getFailureValue() {
        return this.failureValue;
    }

    public String getLogField() {
        return this.logField;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = Base64.encode((String)password);
    }

    public void setQueryDefinition(String queryDefinition) {
        this.queryDefinition = queryDefinition;
    }

    public void setStateField(String stateField) {
        this.stateField = stateField;
    }

    public void setSuccessValue(String successValue) {
        this.successValue = successValue;
    }

    public void setFailureValue(String failureValue) {
        this.failureValue = failureValue;
    }

    public void setLogField(String logField) {
        this.logField = logField;
    }

    private AbstractProject<?, ?> getRootProject(AbstractProject<?, ?> abstractProject) {
        if (abstractProject.getParent() instanceof Hudson) {
            return abstractProject;
        }
        return this.getRootProject((AbstractProject)abstractProject.getParent());
    }

    public APISession createAPISession() {
        try {
            this.logger.debug((Object)"Creating Integrity API Session...");
            return new APISession(null, 0, this.hostName, this.port, this.userName, Base64.decode((String)this.password), this.secure);
        }
        catch (APIException aex) {
            this.logger.error((Object)"API Exception caught...");
            ExceptionHandler eh = new ExceptionHandler(aex);
            this.logger.error((Object)eh.getMessage());
            this.logger.debug((Object)(eh.getCommand() + " returned exit code " + eh.getExitCode()));
            aex.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        AbstractProject rootProject = this.getRootProject(build.getProject());
        if (!(rootProject.getScm() instanceof IntegritySCM)) {
            listener.getLogger().println("Integrity Item update is being executed for an invalid context!  Current SCM is " + rootProject.getScm() + "!");
            return true;
        }
        APISession api = this.createAPISession();
        if (null == api) {
            this.logger.error((Object)"An API Session could not be established!  Cannot update Integrity Build Item!");
            listener.getLogger().println("An API Session could not be established!  Cannot update Integrity Build Item!");
            return false;
        }
        try {
            try {
                String buildItemID = "";
                Command issues = new Command("im", "issues");
                issues.addOption(new Option("fields", "ID"));
                issues.addOption(new Option("queryDefinition", this.queryDefinition));
                Response issuesResponse = api.runCommand(issues);
                if (null == issuesResponse) {
                    listener.getLogger().println("Cannot find an Integrity Build Item!  Response from executing custom query is null!");
                    boolean wit = false;
                    return wit;
                }
                WorkItemIterator wit = issuesResponse.getWorkItems();
                if (!wit.hasNext()) {
                    listener.getLogger().println("Cannot find an Integrity Build Item!  Response from executing custom query is null!");
                    boolean bl = false;
                    return bl;
                }
                buildItemID = wit.next().getField("ID").getValueAsString();
                Command editIssue = new Command("im", "editissue");
                if (null != this.logField && this.logField.length() > 0) {
                    StringWriter writer = new StringWriter();
                    build.getLogText().writeHtmlTo(0L, (Writer)writer);
                    writer.flush();
                    writer.close();
                    String log = writer.getBuffer().toString().replace('\u0000', ' ');
                    log = log.replaceAll(IntegritySCM.NL, "<br>");
                    MultiValue mvLog = new MultiValue("=");
                    mvLog.add(this.logField);
                    mvLog.add(log);
                    editIssue.addOption(new Option("richContentField", mvLog));
                }
                MultiValue mvState = new MultiValue("=");
                mvState.add(this.stateField);
                if (Result.SUCCESS.equals((Object)build.getResult())) {
                    listener.getLogger().println("Preparing to update item '" + buildItemID + "' with value " + this.stateField + " = " + this.successValue);
                    mvState.add(this.successValue);
                } else {
                    listener.getLogger().println("Preparing to update item '" + buildItemID + "' with values " + this.stateField + " = " + this.failureValue);
                    mvState.add(this.failureValue);
                }
                editIssue.addOption(new Option("field", mvState));
                editIssue.addSelection(buildItemID);
                Response editIssueResponse = api.runCommand(editIssue);
                this.logger.debug((Object)(editIssueResponse.getCommandString() + " returned " + editIssueResponse.getExitCode()));
                listener.getLogger().println("Updated build item '" + buildItemID + "' with build status!");
                return true;
            }
            catch (APIException aex) {
                this.logger.error((Object)"API Exception caught...");
                ExceptionHandler eh = new ExceptionHandler(aex);
                this.logger.error((Object)eh.getMessage());
                this.logger.debug((Object)(eh.getCommand() + " returned exit code " + eh.getExitCode()));
                throw new Exception(eh.getMessage());
            }
            finally {
                api.Terminate();
            }
        }
        catch (Throwable e) {
            e.printStackTrace(listener.fatalError(e.getMessage()));
            this.logger.error((Object)("Exception caught!  " + e));
            return false;
        }
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return ITEM_DESCRIPTOR;
    }
}

