/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.scm.CM_PROJECT;
import hudson.scm.IntegritySCM;
import hudson.scm.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class DerbyUtils {
    public static final String DERBY_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String DERBY_SYS_HOME_PROPERTY = "derby.system.home";
    public static final String DERBY_DB_FOLDER = "IntegritySCM";
    public static final String CREATE_PROJECT_TABLE = "CREATE TABLE CM_PROJECT (" + CM_PROJECT.ID + " INTEGER NOT NULL " + "PRIMARY KEY GENERATED ALWAYS AS IDENTITY " + "(START WITH 1, INCREMENT BY 1), " + CM_PROJECT.TYPE + " SMALLINT NOT NULL, " + CM_PROJECT.NAME + " VARCHAR(32500) NOT NULL, " + CM_PROJECT.MEMBER_ID + " VARCHAR(32500), " + CM_PROJECT.TIMESTAMP + " TIMESTAMP, " + CM_PROJECT.DESCRIPTION + " CLOB(4 M), " + CM_PROJECT.AUTHOR + " VARCHAR(100), " + CM_PROJECT.CONFIG_PATH + " VARCHAR(32500), " + CM_PROJECT.REVISION + " VARCHAR(30), " + CM_PROJECT.OLD_REVISION + " VARCHAR(30), " + CM_PROJECT.RELATIVE_FILE + " VARCHAR(32500), " + CM_PROJECT.CHECKSUM + " VARCHAR(32), " + CM_PROJECT.DELTA + " SMALLINT)";
    public static final String DROP_PROJECT_TABLE = "DROP TABLE CM_PROJECT";
    public static final String CREATE_NAME_INDEX = "CREATE INDEX MEMBER_NAME ON CM_PROJECT (" + CM_PROJECT.NAME + " ASC)";
    public static final String DROP_NAME_INDEX = "DROP INDEX MEMBER_NAME";
    public static final String SELECT_MEMBER_1 = "SELECT " + CM_PROJECT.ID + " FROM CM_PROJECT WHERE " + CM_PROJECT.ID + " = 1";
    public static final String INSERT_MEMBER_RECORD = "INSERT INTO CM_PROJECT (" + CM_PROJECT.TYPE + ", " + CM_PROJECT.NAME + ", " + CM_PROJECT.MEMBER_ID + ", " + CM_PROJECT.TIMESTAMP + ", " + CM_PROJECT.DESCRIPTION + ", " + CM_PROJECT.CONFIG_PATH + ", " + CM_PROJECT.REVISION + ", " + CM_PROJECT.RELATIVE_FILE + ") " + "VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    public static final String BASELINE_SELECT = "SELECT " + CM_PROJECT.NAME + ", " + CM_PROJECT.MEMBER_ID + ", " + CM_PROJECT.TIMESTAMP + ", " + CM_PROJECT.DESCRIPTION + ", " + CM_PROJECT.AUTHOR + ", " + CM_PROJECT.CONFIG_PATH + ", " + CM_PROJECT.REVISION + ", " + CM_PROJECT.RELATIVE_FILE + ", " + CM_PROJECT.CHECKSUM + " FROM CM_PROJECT WHERE " + CM_PROJECT.TYPE + " = 0 AND (" + CM_PROJECT.DELTA + " IS NULL OR " + CM_PROJECT.DELTA + " <> 3)";
    public static final String DELTA_SELECT = "SELECT " + CM_PROJECT.TYPE + ", " + CM_PROJECT.NAME + ", " + CM_PROJECT.MEMBER_ID + ", " + CM_PROJECT.TIMESTAMP + ", " + CM_PROJECT.DESCRIPTION + ", " + CM_PROJECT.AUTHOR + ", " + CM_PROJECT.CONFIG_PATH + ", " + CM_PROJECT.REVISION + ", " + CM_PROJECT.OLD_REVISION + ", " + CM_PROJECT.RELATIVE_FILE + ", " + CM_PROJECT.CHECKSUM + ", " + CM_PROJECT.DELTA + " FROM CM_PROJECT WHERE " + CM_PROJECT.TYPE + " = 0";
    public static final String PROJECT_SELECT = "SELECT " + CM_PROJECT.NAME + ", " + CM_PROJECT.MEMBER_ID + ", " + CM_PROJECT.TIMESTAMP + ", " + CM_PROJECT.DESCRIPTION + ", " + CM_PROJECT.AUTHOR + ", " + CM_PROJECT.CONFIG_PATH + ", " + CM_PROJECT.REVISION + ", " + CM_PROJECT.OLD_REVISION + ", " + CM_PROJECT.RELATIVE_FILE + ", " + CM_PROJECT.CHECKSUM + ", " + CM_PROJECT.DELTA + " FROM CM_PROJECT WHERE " + CM_PROJECT.TYPE + " = 0 ORDER BY " + CM_PROJECT.NAME + " ASC";
    public static final String AUTHOR_SELECT = "SELECT " + CM_PROJECT.NAME + ", " + CM_PROJECT.MEMBER_ID + ", " + CM_PROJECT.AUTHOR + ", " + CM_PROJECT.CONFIG_PATH + ", " + CM_PROJECT.REVISION + " FROM CM_PROJECT WHERE " + CM_PROJECT.TYPE + " = 0 AND (" + CM_PROJECT.DELTA + " IS NULL OR " + CM_PROJECT.DELTA + " <> 3)";
    public static final String DIR_SELECT = "SELECT DISTINCT " + CM_PROJECT.RELATIVE_FILE + " FROM CM_PROJECT WHERE " + CM_PROJECT.TYPE + " = 1 ORDER BY " + CM_PROJECT.RELATIVE_FILE + " ASC";
    public static final String CHECKSUM_UPDATE = "SELECT " + CM_PROJECT.NAME + ", " + CM_PROJECT.CHECKSUM + " FROM CM_PROJECT WHERE " + CM_PROJECT.TYPE + " = 0 AND (" + CM_PROJECT.DELTA + " IS NULL OR " + CM_PROJECT.DELTA + " <> 3)";

    public static final CM_PROJECT getEnum(String name) {
        CM_PROJECT[] values = CM_PROJECT.values();
        for (int i = 0; i < values.length; ++i) {
            if (!name.equals(values[i].toString())) continue;
            return values[i];
        }
        return CM_PROJECT.UNDEFINED;
    }

    public static void setDerbySystemDir(File dir) {
        System.setProperty("derby.system.home", dir.getAbsolutePath());
    }

    public static void loadDerbyDriver() {
        try {
            Logger.debug((Object)"Loading derby driver: org.apache.derby.jdbc.EmbeddedDriver");
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        }
        catch (ClassNotFoundException ex) {
            Logger.error((Object)"Failed to load derby driver: org.apache.derby.jdbc.EmbeddedDriver");
            Logger.error((Object)ex.getMessage());
            Logger.fatal((Object)ex);
        }
    }

    public static Connection createDBConnection(File path) throws SQLException {
        String dbUrl = "jdbc:derby:" + path.getAbsolutePath().replace('\\', '/') + "/" + "IntegritySCM" + ";create=true;user=dbuser;password=dbuserpwd";
        Logger.debug((Object)("Attempting to open connection to database: " + path.getAbsolutePath() + IntegritySCM.FS + "IntegritySCM"));
        return DriverManager.getConnection(dbUrl);
    }

    public static void shutdownDB(File path) {
        String dbUrl = "jdbc:derby:" + path.getAbsolutePath().replace('\\', '/') + "/" + "IntegritySCM" + ";shutdown=true;user=dbuser;password=dbuserpwd";
        try {
            Logger.debug((Object)("Attempting to shut down database: " + path.getAbsolutePath() + IntegritySCM.FS + "IntegritySCM"));
            Connection db = DriverManager.getConnection(dbUrl);
            db.close();
        }
        catch (SQLException sqle) {
            Logger.error((Object)"Failed to shutdown database connection!");
            Logger.error((Object)sqle.getMessage());
            Logger.fatal((Object)sqle);
        }
    }

    private static boolean dropTables(Connection db) throws SQLException {
        boolean tablesDropped = false;
        Statement dropIndx = db.createStatement();
        tablesDropped = dropIndx.execute("DROP INDEX MEMBER_NAME");
        dropIndx.close();
        Statement dropTable = db.createStatement();
        tablesDropped = dropTable.execute("DROP TABLE CM_PROJECT");
        dropTable.close();
        Logger.debug((Object)"Prior Integrity SCM cache tables successfully dropped!");
        return tablesDropped;
    }

    private static boolean createTables(Connection db) throws SQLException {
        boolean tablesCreated = false;
        Statement createTable = db.createStatement();
        tablesCreated = createTable.execute(CREATE_PROJECT_TABLE);
        createTable.close();
        Statement createIndex = db.createStatement();
        tablesCreated = createIndex.execute(CREATE_NAME_INDEX);
        createIndex.close();
        Logger.debug((Object)"New Integrity SCM cache tables successfully created!");
        return tablesCreated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean createCMProjectTables(Connection db) {
        boolean tablesCreated = false;
        Statement select = null;
        select = db.createStatement();
        if (select.execute(SELECT_MEMBER_1)) {
            try {
                Logger.debug((Object)"A prior set of Integrity SCM cache tables detected, dropping...");
                select.close();
                tablesCreated = DerbyUtils.dropTables((Connection)db);
                Logger.debug((Object)"Recreating a fresh set of Integrity SCM cache tables...");
                tablesCreated = DerbyUtils.createTables((Connection)db);
            }
            catch (SQLException ex) {
                Logger.error((Object)"Failed to create Integrity SCM cache tables!");
                Logger.fatal((Object)ex);
                tablesCreated = false;
            }
        }
        Object var6_5 = null;
        if (null == select) return tablesCreated;
        try {
            select.close();
            return tablesCreated;
        }
        catch (SQLException ex2) {
            Logger.error((Object)ex2.getMessage());
            Logger.fatal((Object)ex2);
            return false;
        }
        {
            catch (SQLException ex) {
                Logger.debug((Object)ex.getMessage());
                try {
                    Logger.debug((Object)"Integrity SCM cache tables do not exist, creating...");
                    tablesCreated = DerbyUtils.createTables((Connection)db);
                }
                catch (SQLException sqlex) {
                    Logger.error((Object)"Failed to create Integrity SCM cache tables!");
                    Logger.fatal((Object)sqlex);
                    tablesCreated = false;
                }
                Object var6_6 = null;
                if (null == select) return tablesCreated;
                try {
                    select.close();
                    return tablesCreated;
                }
                catch (SQLException ex2) {
                    Logger.error((Object)ex2.getMessage());
                    Logger.fatal((Object)ex2);
                    return false;
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (null == select) throw throwable;
            try {
                select.close();
                throw throwable;
            }
            catch (SQLException ex2) {
                Logger.error((Object)ex2.getMessage());
                Logger.fatal((Object)ex2);
                tablesCreated = false;
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable<CM_PROJECT, Object> getRowData(ResultSet rs) throws SQLException, IOException {
        Hashtable<CM_PROJECT, Object> rowData = new Hashtable<CM_PROJECT, Object>();
        ResultSetMetaData rsMetaData = rs.getMetaData();
        int columns = rsMetaData.getColumnCount();
        block20: for (int i = 1; i <= columns; ++i) {
            int columnType = rsMetaData.getColumnType(i);
            Object value = null;
            switch (columnType) {
                case 2003: {
                    value = rs.getArray(i);
                    if (rs.wasNull()) continue block20;
                    rowData.put(DerbyUtils.getEnum((String)rsMetaData.getColumnLabel(i)), rs.getArray(i));
                    continue block20;
                }
                case -5: 
                case 2: 
                case 7: {
                    value = rs.getLong(i);
                    if (rs.wasNull()) continue block20;
                    rowData.put(DerbyUtils.getEnum((String)rsMetaData.getColumnLabel(i)), rs.getLong(i));
                    continue block20;
                }
                case 2004: {
                    Object var10_11;
                    value = rs.getBlob(i);
                    if (rs.wasNull()) continue block20;
                    InputStream is = rs.getBlob(i).getBinaryStream();
                    try {
                        byte[] bytes = IOUtils.toByteArray((InputStream)is);
                        rowData.put(DerbyUtils.getEnum((String)rsMetaData.getColumnLabel(i)), bytes);
                        var10_11 = null;
                    }
                    catch (Throwable throwable) {
                        var10_11 = null;
                        is.close();
                        throw throwable;
                    }
                    is.close();
                    continue block20;
                }
                case 16: {
                    value = rs.getBoolean(i);
                    if (rs.wasNull()) continue block20;
                    rowData.put(DerbyUtils.getEnum((String)rsMetaData.getColumnLabel(i)), rs.getBoolean(i));
                    continue block20;
                }
                case 2005: {
                    Object var12_12;
                    value = rs.getClob(i);
                    if (rs.wasNull()) continue block20;
                    BufferedReader reader = new BufferedReader(rs.getClob(i).getCharacterStream());
                    String line = null;
                    StringBuilder sb = new StringBuilder();
                    try {
                        while (null != (line = reader.readLine())) {
                            sb.append(line + IntegritySCM.NL);
                        }
                        rowData.put(DerbyUtils.getEnum((String)rsMetaData.getColumnLabel(i)), sb.toString());
                        var12_12 = null;
                    }
                    catch (Throwable throwable) {
                        var12_12 = null;
                        reader.close();
                        throw throwable;
                    }
                    reader.close();
                    continue block20;
                }
                case 91: {
                    value = rs.getDate(i);
                    if (rs.wasNull()) continue block20;
                    rowData.put(DerbyUtils.getEnum((String)rsMetaData.getColumnLabel(i)), rs.getDate(i));
                    continue block20;
                }
                case 3: {
                    value = rs.getBigDecimal(i);
                    if (rs.wasNull()) continue block20;
                    rowData.put(DerbyUtils.getEnum((String)rsMetaData.getColumnLabel(i)), rs.getBigDecimal(i));
                    continue block20;
                }
                case 8: {
                    value = rs.getDouble(i);
                    if (rs.wasNull()) continue block20;
                    rowData.put(DerbyUtils.getEnum((String)rsMetaData.getColumnLabel(i)), rs.getDouble(i));
                    continue block20;
                }
                case 6: {
                    value = Float.valueOf(rs.getFloat(i));
                    if (rs.wasNull()) continue block20;
                    rowData.put(DerbyUtils.getEnum((String)rsMetaData.getColumnLabel(i)), Float.valueOf(rs.getFloat(i)));
                    continue block20;
                }
                case 4: {
                    value = rs.getInt(i);
                    if (rs.wasNull()) continue block20;
                    rowData.put(DerbyUtils.getEnum((String)rsMetaData.getColumnLabel(i)), rs.getInt(i));
                    continue block20;
                }
                case 2000: {
                    value = rs.getObject(i);
                    if (rs.wasNull()) continue block20;
                    rowData.put(DerbyUtils.getEnum((String)rsMetaData.getColumnLabel(i)), rs.getObject(i));
                    continue block20;
                }
                case -6: 
                case 5: {
                    value = rs.getShort(i);
                    if (rs.wasNull()) continue block20;
                    rowData.put(DerbyUtils.getEnum((String)rsMetaData.getColumnLabel(i)), rs.getShort(i));
                    continue block20;
                }
                case 92: {
                    value = rs.getTime(i);
                    if (rs.wasNull()) continue block20;
                    rowData.put(DerbyUtils.getEnum((String)rsMetaData.getColumnLabel(i)), rs.getTime(i));
                    continue block20;
                }
                case 93: {
                    value = rs.getTimestamp(i);
                    if (rs.wasNull()) continue block20;
                    rowData.put(DerbyUtils.getEnum((String)rsMetaData.getColumnLabel(i)), rs.getTimestamp(i));
                    continue block20;
                }
                default: {
                    value = rs.getString(i);
                    if (rs.wasNull()) continue block20;
                    rowData.put(DerbyUtils.getEnum((String)rsMetaData.getColumnLabel(i)), rs.getString(i));
                }
            }
        }
        return rowData;
    }

    public static int getRowCount(ResultSet rs) throws SQLException {
        int rowCount = 0;
        int currentRow = rs.getRow();
        int n = rowCount = rs.last() ? rs.getRow() : rowCount;
        if (currentRow == 0) {
            rs.beforeFirst();
        } else {
            rs.absolute(currentRow);
        }
        return rowCount;
    }
}

