/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.mks.api.Command;
import com.mks.api.FileOption;
import com.mks.api.Option;
import com.mks.api.response.APIException;
import com.mks.api.response.Response;
import hudson.scm.APISession;
import hudson.scm.ExceptionHandler;
import hudson.scm.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.codec.digest.DigestUtils;

public final class IntegrityCMMember {
    private static final String ENCODING = "UTF-8";

    public static final String getName(String memberID) {
        if (memberID.indexOf(47) > 0) {
            return memberID.substring(memberID.lastIndexOf(47) + 1);
        }
        if (memberID.indexOf(92) > 0) {
            return memberID.substring(memberID.lastIndexOf(92) + 1);
        }
        return memberID;
    }

    public static final String getAnnotatedLink(String configPath, String memberID, String memberRev) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append("annotate?projectName=");
        sb.append(URLEncoder.encode(configPath, ENCODING));
        sb.append("&revision=");
        sb.append(memberRev);
        sb.append("&selection=");
        sb.append(URLEncoder.encode(memberID, ENCODING));
        return sb.toString();
    }

    public static final String getDifferencesLink(String configPath, String memberID, String memberRev, String oldMemberRev) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append("diff?projectName=");
        sb.append(URLEncoder.encode(configPath, ENCODING));
        sb.append("&oldRevision=");
        sb.append(oldMemberRev);
        sb.append("&newRevision=");
        sb.append(memberRev);
        sb.append("&selection=");
        sb.append(URLEncoder.encode(memberID, ENCODING));
        return sb.toString();
    }

    public static final boolean checkout(APISession api, String configPath, String memberID, String memberRev, File targetFile, boolean restoreTimestamp, String lineTerminator) throws APIException {
        if (!targetFile.getParentFile().isDirectory()) {
            targetFile.getParentFile().mkdirs();
        }
        Command coCMD = new Command("si", "projectco");
        coCMD.addOption(new Option("overwriteExisting"));
        coCMD.addOption(new Option("nolock"));
        coCMD.addOption(new Option("project", configPath));
        coCMD.addOption((Option)new FileOption("targetFile", targetFile));
        coCMD.addOption(new Option(restoreTimestamp ? "restoreTimestamp" : "norestoreTimestamp"));
        coCMD.addOption(new Option("lineTerminator", lineTerminator));
        coCMD.addOption(new Option("revision", memberRev));
        coCMD.addSelection(memberID);
        Response res = api.runCommand(coCMD);
        Logger.debug((Object)("Command: " + res.getCommandString() + " completed with exit code " + res.getExitCode()));
        return res.getExitCode() == 0;
    }

    public static String getAuthor(APISession api, String configPath, String memberID, String memberRev) {
        String author = "unknown";
        Command revInfoCMD = new Command("si", "revisioninfo");
        revInfoCMD.addOption(new Option("project", configPath));
        revInfoCMD.addOption(new Option("revision", memberRev));
        revInfoCMD.addSelection(memberID);
        try {
            Response res = api.runCommand(revInfoCMD);
            Logger.debug((Object)("Command: " + res.getCommandString() + " completed with exit code " + res.getExitCode()));
            if (res.getExitCode() == 0) {
                author = res.getWorkItem(memberID).getField("author").getValueAsString();
            }
        }
        catch (APIException aex) {
            ExceptionHandler eh = new ExceptionHandler(aex);
            Logger.error((Object)"API Exception caught...");
            Logger.error((Object)eh.getMessage());
            Logger.debug((Object)(eh.getCommand() + " returned exit code " + eh.getExitCode()));
            aex.printStackTrace();
        }
        return author;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String getMD5Checksum(File targetFile) throws IOException {
        String result = "";
        InputStream fis = null;
        try {
            try {
                Logger.debug((Object)("Generating checksum for file " + targetFile.getAbsolutePath()));
                fis = new FileInputStream(targetFile);
                result = DigestUtils.md5Hex((InputStream)fis);
            }
            catch (FileNotFoundException fnfe) {
                result = "";
                Object var5_4 = null;
                if (null == fis) return result;
                fis.close();
                return result;
            }
            Object var5_3 = null;
            if (null == fis) return result;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (null == fis) throw throwable;
            fis.close();
            throw throwable;
        }
        fis.close();
        return result;
    }
}

