/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.mks.api.response.APIException;
import com.mks.api.response.Response;
import com.mks.api.response.WorkItem;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.scm.APISession;
import hudson.scm.ExceptionHandler;
import hudson.scm.IntegrityCMProject;
import hudson.scm.IntegrityCheckpointAction;
import hudson.scm.IntegritySCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrityCheckpointAction
extends Notifier {
    private String tagName;
    private final Log logger = LogFactory.getLog(this.getClass());
    @Extension
    public static final IntegrityCheckpointDescriptorImpl CHECKPOINT_DESCRIPTOR = new IntegrityCheckpointDescriptorImpl();

    public String getTagName() {
        if (this.tagName == null || this.tagName.length() == 0) {
            return CHECKPOINT_DESCRIPTOR.getDefaultTagName();
        }
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    private AbstractProject<?, ?> getRootProject(AbstractProject<?, ?> abstractProject) {
        if (abstractProject.getParent() instanceof Hudson) {
            return abstractProject;
        }
        return this.getRootProject((AbstractProject)abstractProject.getParent());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (!Result.SUCCESS.equals((Object)build.getResult())) {
            listener.getLogger().println("Build failed!  Skipping Integrity Checkpoint step!");
            return true;
        }
        AbstractProject rootProject = this.getRootProject(build.getProject());
        if (!(rootProject.getScm() instanceof IntegritySCM)) {
            listener.getLogger().println("Integrity Checkpoint is being executed for an invalid context!  Current SCM is " + rootProject.getScm() + "!");
            return true;
        }
        IntegritySCM scm = (IntegritySCM)IntegritySCM.class.cast(rootProject.getScm());
        APISession api = scm.createAPISession();
        if (null == api) {
            this.logger.error((Object)"An API Session could not be established!  Cannot perform checkpoint operation!");
            listener.getLogger().println("An API Session could not be established!  Cannot perform checkpoint operation!");
            return false;
        }
        EnvVars env = build.getEnvironment((TaskListener)listener);
        String chkptLabel = CHECKPOINT_DESCRIPTOR.evalGroovyExpression((Map)env, this.tagName);
        try {
            try {
                try {
                    IntegrityCMProject siProject = scm.getIntegrityProject();
                    if (!siProject.isBuild()) {
                        listener.getLogger().println("Preparing to execute si checkpoint for " + siProject.getConfigurationPath());
                        Response res = siProject.checkpoint(api, chkptLabel);
                        this.logger.debug((Object)(res.getCommandString() + " returned " + res.getExitCode()));
                        WorkItem wi = res.getWorkItem(siProject.getConfigurationPath());
                        String chkpt = wi.getResult().getField("resultant").getItem().getId();
                        listener.getLogger().println("Successfully checkpointed project " + scm.getConfigPath() + " with label '" + chkptLabel + "', new revision is " + chkpt);
                    }
                    if (scm.getCheckpointBeforeBuild()) {
                        listener.getLogger().println("Preparing to execute si addprojectlabel for " + siProject.getConfigurationPath());
                        Response res = siProject.addProjectLabel(api, chkptLabel);
                        this.logger.debug((Object)(res.getCommandString() + " returned " + res.getExitCode()));
                        listener.getLogger().println("Successfully added label '" + chkptLabel + "' to revision " + siProject.getProjectRevision());
                    }
                    listener.getLogger().println("Cannot checkpoint a build project configuration: " + scm.getConfigPath() + "!");
                }
                catch (APIException aex) {
                    this.logger.error((Object)"API Exception caught...");
                    ExceptionHandler eh = new ExceptionHandler(aex);
                    this.logger.error((Object)eh.getMessage());
                    this.logger.debug((Object)(eh.getCommand() + " returned exit code " + eh.getExitCode()));
                    throw new Exception(eh.getMessage());
                }
                Object var14_17 = null;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                api.Terminate();
                throw throwable;
            }
            api.Terminate();
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace(listener.fatalError(e.getMessage()));
            this.logger.error((Object)("Exception caught!  " + e));
            return false;
        }
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return CHECKPOINT_DESCRIPTOR;
    }
}

