/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.mks.api.Command;
import com.mks.api.Option;
import com.mks.api.response.APIException;
import com.mks.api.response.Field;
import com.mks.api.response.Response;
import com.mks.api.response.WorkItem;
import com.mks.api.response.WorkItemIterator;
import hudson.scm.APISession;
import hudson.scm.CM_PROJECT;
import hudson.scm.DerbyUtils;
import hudson.scm.IntegrityCMMember;
import hudson.scm.IntegritySCM;
import hudson.scm.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrityCMProject
implements Serializable {
    private static final long serialVersionUID = 6452315129657215760L;
    public static final String NORMAL_PROJECT = "Normal";
    public static final String VARIANT_PROJECT = "Variant";
    public static final String BUILD_PROJECT = "Build";
    private File projectDB;
    private String projectName;
    private String projectType;
    private String projectRevision;
    private String fullConfigSyntax;
    private Date lastCheckpoint;
    private String lineTerminator = "native";
    private boolean restoreTimestamp = true;
    private boolean skipAuthorInfo = false;
    private Document xmlDoc;
    private StringBuffer changeLog;
    private transient int changeCount;

    public IntegrityCMProject(WorkItem wi, File projectDB) {
        this.projectDB = projectDB;
        this.changeLog = new StringBuffer();
        this.changeCount = 0;
        this.initializeProject(wi);
    }

    public void initializeProject(WorkItem wi) {
        try {
            Field pjNameFld = wi.getField("projectName");
            Field pjTypeFld = wi.getField("projectType");
            Field pjCfgPathFld = wi.getField("fullConfigSyntax");
            Field pjChkptFld = wi.getField("lastCheckpoint");
            if (null != pjNameFld && null != pjNameFld.getValueAsString()) {
                this.projectName = pjNameFld.getValueAsString();
            } else {
                Logger.warn("Project info did not provide a value for the 'projectName' field!");
                this.projectName = "";
            }
            if (null != pjTypeFld && null != pjTypeFld.getValueAsString()) {
                this.projectType = pjTypeFld.getValueAsString();
                if (this.isBuild()) {
                    Field pjRevFld = wi.getField("revision");
                    if (null != pjRevFld && null != pjRevFld.getItem()) {
                        this.projectRevision = pjRevFld.getItem().getId();
                    } else {
                        this.projectRevision = "";
                        Logger.warn("Project info did not provide a vale for the 'revision' field!");
                    }
                }
            } else {
                Logger.warn("Project info did not provide a value for the 'projectType' field!");
                this.projectType = "";
            }
            if (null != pjCfgPathFld && null != pjCfgPathFld.getValueAsString()) {
                this.fullConfigSyntax = pjCfgPathFld.getValueAsString();
            } else {
                Logger.error("Project info did not provide a value for the 'fullConfigSyntax' field!");
                this.fullConfigSyntax = "";
            }
            if (null != pjChkptFld && null != pjChkptFld.getDateTime()) {
                this.lastCheckpoint = pjChkptFld.getDateTime();
            } else {
                Logger.warn("Project info did not provide a value for the 'lastCheckpoint' field!");
                this.lastCheckpoint = Calendar.getInstance().getTime();
            }
        }
        catch (NoSuchElementException nsee) {
            Logger.error("Project info did not provide a value for field " + nsee.getMessage());
        }
    }

    public void setLineTerminator(String lineTerminator) {
        this.lineTerminator = lineTerminator;
    }

    public String getLineTerminator() {
        return this.lineTerminator;
    }

    public void setRestoreTimestamp(boolean restoreTimestamp) {
        this.restoreTimestamp = restoreTimestamp;
    }

    public boolean getRestoreTimestamp() {
        return this.restoreTimestamp;
    }

    public void setSkipAuthorInfo(boolean skipAuthorInfo) {
        this.skipAuthorInfo = skipAuthorInfo;
    }

    public Connection openProjectDB() throws SQLException {
        return DerbyUtils.createDBConnection(this.projectDB);
    }

    public void closeProjectDB() {
        DerbyUtils.shutdownDB(this.projectDB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseProject(WorkItemIterator wit) throws APIException, SQLException {
        Connection db = this.openProjectDB();
        Statement insert = null;
        try {
            DerbyUtils.createCMProjectTables(db);
            Hashtable<String, String> pjConfigHash = new Hashtable<String, String>();
            pjConfigHash.put(this.projectName, this.fullConfigSyntax);
            String projectRoot = this.projectName.substring(0, this.projectName.lastIndexOf(47));
            Logger.debug("Attempting to execute query " + DerbyUtils.INSERT_MEMBER_RECORD);
            insert = db.prepareStatement(DerbyUtils.INSERT_MEMBER_RECORD);
            while (wit.hasNext()) {
                WorkItem wi = wit.next();
                if (wi.getModelType().equals("si.Subproject")) {
                    pjConfigHash.put(wi.getField("name").getValueAsString(), wi.getId());
                    String pjDir = wi.getField("name").getValueAsString().substring(projectRoot.length());
                    pjDir = pjDir.substring(0, pjDir.lastIndexOf(47));
                    insert.clearParameters();
                    insert.setShort(1, (short)1);
                    insert.setString(2, wi.getField("name").getValueAsString());
                    insert.setString(3, wi.getId());
                    insert.setTimestamp(4, new Timestamp(Calendar.getInstance().getTimeInMillis()));
                    insert.setClob(5, new StringReader(""));
                    insert.setString(6, wi.getId());
                    insert.setString(7, "");
                    insert.setString(8, pjDir);
                    insert.executeUpdate();
                    continue;
                }
                if (wi.getModelType().equals("si.Member")) {
                    String parentProject = wi.getField("parent").getValueAsString();
                    String memberName = wi.getField("name").getValueAsString();
                    String description = "";
                    if (null != wi.getField("memberdescription") && null != wi.getField("memberdescription").getValueAsString()) {
                        description = wi.getField("memberdescription").getValueAsString();
                        description = description.replace('\u2013', '-');
                    }
                    insert.clearParameters();
                    insert.setShort(1, (short)0);
                    insert.setString(2, memberName);
                    insert.setString(3, wi.getId());
                    insert.setTimestamp(4, new Timestamp(wi.getField("membertimestamp").getDateTime().getTime()));
                    insert.setClob(5, new StringReader(description));
                    insert.setString(6, (String)pjConfigHash.get(parentProject));
                    insert.setString(7, wi.getField("memberrev").getItem().getId());
                    insert.setString(8, memberName.substring(projectRoot.length()));
                    insert.executeUpdate();
                    continue;
                }
                Logger.warn("View project output contains an invalid model type: " + wi.getModelType());
            }
            db.commit();
        }
        finally {
            if (null != insert) {
                insert.close();
            }
            if (null != db) {
                db.close();
            }
        }
        Logger.debug("Parsing project " + this.fullConfigSyntax + " complete!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void primeAuthorInformation(APISession api) throws SQLException, IOException {
        Connection db = this.openProjectDB();
        Statement authSelect = null;
        ResultSet rs = null;
        try {
            authSelect = db.createStatement(1004, 1008);
            rs = authSelect.executeQuery(DerbyUtils.AUTHOR_SELECT);
            while (rs.next()) {
                Hashtable<CM_PROJECT, Object> rowHash = DerbyUtils.getRowData(rs);
                rs.updateString(CM_PROJECT.AUTHOR.toString(), IntegrityCMMember.getAuthor(api, rowHash.get((Object)CM_PROJECT.CONFIG_PATH).toString(), rowHash.get((Object)CM_PROJECT.MEMBER_ID).toString(), rowHash.get((Object)CM_PROJECT.REVISION).toString()));
                rs.updateRow();
            }
            db.commit();
        }
        finally {
            if (null != rs) {
                rs.close();
            }
            if (null != authSelect) {
                authSelect.close();
            }
            if (null != db) {
                db.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateChecksum(Hashtable<String, String> checksumHash) throws SQLException, IOException {
        Connection db = this.openProjectDB();
        Statement checksumSelect = null;
        ResultSet rs = null;
        try {
            checksumSelect = db.createStatement(1004, 1008);
            rs = checksumSelect.executeQuery(DerbyUtils.CHECKSUM_UPDATE);
            while (rs.next()) {
                Hashtable<CM_PROJECT, Object> rowHash = DerbyUtils.getRowData(rs);
                String newChecksum = checksumHash.get(rowHash.get((Object)CM_PROJECT.NAME).toString());
                if (null == newChecksum || newChecksum.length() <= 0) continue;
                rs.updateString(CM_PROJECT.CHECKSUM.toString(), newChecksum);
                rs.updateRow();
            }
            db.commit();
        }
        finally {
            if (null != rs) {
                rs.close();
            }
            if (null != checksumSelect) {
                checksumSelect.close();
            }
            if (null != db) {
                db.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compareBaseline(File baselineProjectDB, APISession api) throws SQLException, IOException {
        ResultSet rs;
        Statement pjSelect;
        Statement baselineSelect;
        Connection db;
        Connection baselineDB;
        block25: {
            this.changeCount = 0;
            baselineDB = DerbyUtils.createDBConnection(baselineProjectDB);
            db = this.openProjectDB();
            baselineSelect = null;
            pjSelect = null;
            ResultSet baselineRS = null;
            rs = null;
            try {
                baselineSelect = baselineDB.createStatement();
                Logger.debug("Attempting to execute query " + DerbyUtils.BASELINE_SELECT);
                baselineRS = baselineSelect.executeQuery(DerbyUtils.BASELINE_SELECT);
                Hashtable baselinePJ = new Hashtable();
                while (baselineRS.next()) {
                    Hashtable<CM_PROJECT, Object> rowHash = DerbyUtils.getRowData(baselineRS);
                    Hashtable<CM_PROJECT, Object> memberInfo = new Hashtable<CM_PROJECT, Object>();
                    memberInfo.put(CM_PROJECT.MEMBER_ID, null == rowHash.get((Object)CM_PROJECT.MEMBER_ID) ? "" : rowHash.get((Object)CM_PROJECT.MEMBER_ID).toString());
                    memberInfo.put(CM_PROJECT.TIMESTAMP, null == rowHash.get((Object)CM_PROJECT.TIMESTAMP) ? "" : (Date)rowHash.get((Object)CM_PROJECT.TIMESTAMP));
                    memberInfo.put(CM_PROJECT.DESCRIPTION, null == rowHash.get((Object)CM_PROJECT.DESCRIPTION) ? "" : rowHash.get((Object)CM_PROJECT.DESCRIPTION).toString());
                    memberInfo.put(CM_PROJECT.AUTHOR, null == rowHash.get((Object)CM_PROJECT.AUTHOR) ? "" : rowHash.get((Object)CM_PROJECT.AUTHOR).toString());
                    memberInfo.put(CM_PROJECT.CONFIG_PATH, null == rowHash.get((Object)CM_PROJECT.CONFIG_PATH) ? "" : rowHash.get((Object)CM_PROJECT.CONFIG_PATH).toString());
                    memberInfo.put(CM_PROJECT.REVISION, null == rowHash.get((Object)CM_PROJECT.REVISION) ? "" : rowHash.get((Object)CM_PROJECT.REVISION).toString());
                    memberInfo.put(CM_PROJECT.RELATIVE_FILE, null == rowHash.get((Object)CM_PROJECT.RELATIVE_FILE) ? "" : rowHash.get((Object)CM_PROJECT.RELATIVE_FILE).toString());
                    memberInfo.put(CM_PROJECT.CHECKSUM, null == rowHash.get((Object)CM_PROJECT.CHECKSUM) ? "" : rowHash.get((Object)CM_PROJECT.CHECKSUM).toString());
                    baselinePJ.put(rowHash.get((Object)CM_PROJECT.NAME).toString(), memberInfo);
                }
                pjSelect = db.createStatement(1004, 1008);
                Logger.debug("Attempting to execute query " + DerbyUtils.DELTA_SELECT);
                rs = pjSelect.executeQuery(DerbyUtils.DELTA_SELECT);
                for (int i = 1; i <= DerbyUtils.getRowCount(rs); ++i) {
                    rs.absolute(i);
                    Hashtable<CM_PROJECT, Object> rowHash = DerbyUtils.getRowData(rs);
                    String memberName = rowHash.get((Object)CM_PROJECT.NAME).toString();
                    Logger.debug("Comparing file against baseline " + memberName);
                    Hashtable baselineMemberInfo = (Hashtable)baselinePJ.get(memberName);
                    if (null != baselineMemberInfo) {
                        String oldRevision = baselineMemberInfo.get((Object)CM_PROJECT.REVISION).toString();
                        if (!rowHash.get((Object)CM_PROJECT.REVISION).toString().equals(oldRevision)) {
                            rs.updateString(CM_PROJECT.OLD_REVISION.toString(), oldRevision);
                            if (!this.skipAuthorInfo) {
                                rs.updateString(CM_PROJECT.AUTHOR.toString(), IntegrityCMMember.getAuthor(api, rowHash.get((Object)CM_PROJECT.CONFIG_PATH).toString(), rowHash.get((Object)CM_PROJECT.MEMBER_ID).toString(), rowHash.get((Object)CM_PROJECT.REVISION).toString()));
                            }
                            rs.updateShort(CM_PROJECT.DELTA.toString(), (short)2);
                            ++this.changeCount;
                        } else {
                            if (null != baselineMemberInfo.get((Object)CM_PROJECT.AUTHOR)) {
                                rs.updateString(CM_PROJECT.AUTHOR.toString(), baselineMemberInfo.get((Object)CM_PROJECT.AUTHOR).toString());
                            }
                            if (null != baselineMemberInfo.get((Object)CM_PROJECT.CHECKSUM)) {
                                rs.updateString(CM_PROJECT.CHECKSUM.toString(), baselineMemberInfo.get((Object)CM_PROJECT.CHECKSUM).toString());
                            }
                            rs.updateShort(CM_PROJECT.DELTA.toString(), (short)0);
                        }
                        baselinePJ.remove(memberName);
                    } else {
                        if (!this.skipAuthorInfo) {
                            rs.updateString(CM_PROJECT.AUTHOR.toString(), IntegrityCMMember.getAuthor(api, rowHash.get((Object)CM_PROJECT.CONFIG_PATH).toString(), rowHash.get((Object)CM_PROJECT.MEMBER_ID).toString(), rowHash.get((Object)CM_PROJECT.REVISION).toString()));
                        }
                        rs.updateShort(CM_PROJECT.DELTA.toString(), (short)1);
                        ++this.changeCount;
                    }
                    rs.updateRow();
                }
                Enumeration deletedMembers = baselinePJ.keys();
                while (deletedMembers.hasMoreElements()) {
                    ++this.changeCount;
                    String memberName = (String)deletedMembers.nextElement();
                    Hashtable memberInfo = (Hashtable)baselinePJ.get(memberName);
                    rs.moveToInsertRow();
                    rs.updateShort(CM_PROJECT.TYPE.toString(), (short)0);
                    rs.updateString(CM_PROJECT.NAME.toString(), memberName);
                    rs.updateString(CM_PROJECT.MEMBER_ID.toString(), memberInfo.get((Object)CM_PROJECT.MEMBER_ID).toString());
                    if (memberInfo.get((Object)CM_PROJECT.TIMESTAMP) instanceof Date) {
                        Timestamp ts = new Timestamp(((Date)memberInfo.get((Object)CM_PROJECT.TIMESTAMP)).getTime());
                        rs.updateTimestamp(CM_PROJECT.TIMESTAMP.toString(), ts);
                    }
                    rs.updateString(CM_PROJECT.DESCRIPTION.toString(), memberInfo.get((Object)CM_PROJECT.DESCRIPTION).toString());
                    rs.updateString(CM_PROJECT.AUTHOR.toString(), memberInfo.get((Object)CM_PROJECT.AUTHOR).toString());
                    rs.updateString(CM_PROJECT.CONFIG_PATH.toString(), memberInfo.get((Object)CM_PROJECT.CONFIG_PATH).toString());
                    rs.updateString(CM_PROJECT.REVISION.toString(), memberInfo.get((Object)CM_PROJECT.REVISION).toString());
                    rs.updateString(CM_PROJECT.RELATIVE_FILE.toString(), memberInfo.get((Object)CM_PROJECT.RELATIVE_FILE).toString());
                    rs.updateShort(CM_PROJECT.DELTA.toString(), (short)3);
                    rs.insertRow();
                    rs.moveToCurrentRow();
                }
                db.commit();
                Object var16_17 = null;
                if (null == baselineRS) break block25;
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                if (null != baselineRS) {
                    baselineRS.close();
                }
                if (null != rs) {
                    rs.close();
                }
                if (null != baselineSelect) {
                    baselineSelect.close();
                }
                if (null != pjSelect) {
                    pjSelect.close();
                }
                if (null != baselineDB) {
                    baselineDB.close();
                }
                if (null != db) {
                    db.close();
                }
                DerbyUtils.shutdownDB(baselineProjectDB);
                throw throwable;
            }
            baselineRS.close();
        }
        if (null != rs) {
            rs.close();
        }
        if (null != baselineSelect) {
            baselineSelect.close();
        }
        if (null != pjSelect) {
            pjSelect.close();
        }
        if (null != baselineDB) {
            baselineDB.close();
        }
        if (null != db) {
            db.close();
        }
        DerbyUtils.shutdownDB(baselineProjectDB);
        return this.changeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Hashtable<CM_PROJECT, Object>> viewProject() throws SQLException, IOException {
        Statement stmt;
        Connection db;
        ArrayList<Hashtable<CM_PROJECT, Object>> projectMembersList;
        block8: {
            projectMembersList = new ArrayList<Hashtable<CM_PROJECT, Object>>();
            db = this.openProjectDB();
            stmt = null;
            ResultSet rs = null;
            try {
                stmt = db.createStatement();
                rs = stmt.executeQuery(DerbyUtils.PROJECT_SELECT);
                while (rs.next()) {
                    projectMembersList.add(DerbyUtils.getRowData(rs));
                }
                Object var6_5 = null;
                if (null == rs) break block8;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (null != rs) {
                    rs.close();
                }
                if (null != stmt) {
                    stmt.close();
                }
                if (null != db) {
                    db.close();
                }
                throw throwable;
            }
            rs.close();
        }
        if (null != stmt) {
            stmt.close();
        }
        if (null != db) {
            db.close();
        }
        return projectMembersList;
    }

    public String getChangeLog(String version, List<Hashtable<CM_PROJECT, Object>> projectMembersList) throws DOMException {
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.xmlDoc = docBuilder.newDocument();
            this.changeLog = new StringBuffer();
            Element changeLogElem = this.xmlDoc.createElement("changelog");
            this.xmlDoc.appendChild(changeLogElem);
            if (this.changeCount > 0) {
                Element items = this.xmlDoc.createElement("items");
                items.setAttribute("version", version);
                changeLogElem.appendChild(items);
                for (Hashtable<CM_PROJECT, Object> memberInfo : projectMembersList) {
                    short deltaFlag = Short.valueOf(memberInfo.get((Object)CM_PROJECT.DELTA).toString());
                    if (deltaFlag <= 0) continue;
                    Element item = this.xmlDoc.createElement("item");
                    if (deltaFlag == 1) {
                        item.setAttribute("action", "add");
                    } else if (deltaFlag == 2) {
                        item.setAttribute("action", "update");
                    } else if (deltaFlag == 3) {
                        item.setAttribute("action", "delete");
                    } else {
                        item.setAttribute("action", "undefined");
                    }
                    items.appendChild(this.writeChangeLog(item, memberInfo));
                }
            }
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer serializer = tfactory.newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StringWriter sw = new StringWriter();
            serializer.transform(new DOMSource(this.xmlDoc), new StreamResult(sw));
            this.changeLog.append(sw.toString());
            sw.close();
        }
        catch (ParserConfigurationException pce) {
            Logger.warn("Caught Parser Configuration Exception while generating Change Log!");
            Logger.warn(pce.getMessage());
        }
        catch (TransformerException tfe) {
            Logger.warn("Caught Transformer Exception while generating Change Log!");
            Logger.warn(tfe.getMessage());
        }
        catch (IOException ioe) {
            Logger.warn("Caught IO Exception while generating Change Log!");
            Logger.warn(ioe.getMessage());
        }
        return this.changeLog.toString();
    }

    private Element writeChangeLog(Element item, Hashtable<CM_PROJECT, Object> memberInfo) {
        Element file = this.xmlDoc.createElement("file");
        file.appendChild(this.xmlDoc.createTextNode(memberInfo.get((Object)CM_PROJECT.NAME).toString()));
        item.appendChild(file);
        Element user = this.xmlDoc.createElement("user");
        user.appendChild(this.xmlDoc.createTextNode(memberInfo.get((Object)CM_PROJECT.AUTHOR).toString()));
        item.appendChild(user);
        Element revision = this.xmlDoc.createElement("rev");
        revision.appendChild(this.xmlDoc.createTextNode(memberInfo.get((Object)CM_PROJECT.REVISION).toString()));
        item.appendChild(revision);
        Element date = this.xmlDoc.createElement("date");
        date.appendChild(this.xmlDoc.createTextNode(IntegritySCM.SDF.format((Timestamp)memberInfo.get((Object)CM_PROJECT.TIMESTAMP))));
        item.appendChild(date);
        try {
            Element annotation = this.xmlDoc.createElement("annotation");
            annotation.appendChild(this.xmlDoc.createCDATASection(IntegrityCMMember.getAnnotatedLink(memberInfo.get((Object)CM_PROJECT.CONFIG_PATH).toString(), memberInfo.get((Object)CM_PROJECT.MEMBER_ID).toString(), memberInfo.get((Object)CM_PROJECT.REVISION).toString())));
            item.appendChild(annotation);
            Element differences = this.xmlDoc.createElement("differences");
            String oldRev = null != memberInfo.get((Object)CM_PROJECT.OLD_REVISION) ? memberInfo.get((Object)CM_PROJECT.OLD_REVISION).toString() : "";
            differences.appendChild(this.xmlDoc.createCDATASection(oldRev.length() > 0 ? IntegrityCMMember.getDifferencesLink(memberInfo.get((Object)CM_PROJECT.CONFIG_PATH).toString(), memberInfo.get((Object)CM_PROJECT.MEMBER_ID).toString(), memberInfo.get((Object)CM_PROJECT.REVISION).toString(), oldRev) : ""));
            item.appendChild(differences);
        }
        catch (UnsupportedEncodingException uee) {
            Logger.warn("Caught Unsupported Encoding Exception while generating Integrity Source links!");
            Logger.warn(uee.getMessage());
        }
        Element msg = this.xmlDoc.createElement("msg");
        msg.appendChild(this.xmlDoc.createCDATASection(memberInfo.get((Object)CM_PROJECT.DESCRIPTION).toString()));
        item.appendChild(msg);
        return item;
    }

    public Response checkpoint(APISession api, String chkptLabel) throws APIException {
        Command siCheckpoint = new Command("si", "checkpoint");
        siCheckpoint.addOption(new Option("project", this.fullConfigSyntax));
        if (null != chkptLabel && chkptLabel.length() > 0) {
            siCheckpoint.addOption(new Option("label", chkptLabel));
            siCheckpoint.addOption(new Option("description", chkptLabel));
        }
        return api.runCommand(siCheckpoint);
    }

    public Response addProjectLabel(APISession api, String chkptLabel) throws APIException {
        Command siAddProjectLabel = new Command("si", "addprojectlabel");
        siAddProjectLabel.addOption(new Option("project", this.fullConfigSyntax));
        siAddProjectLabel.addOption(new Option("label", chkptLabel));
        siAddProjectLabel.addOption(new Option("moveLabel"));
        return api.runCommand(siAddProjectLabel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDirList() throws SQLException, IOException {
        Statement stmt;
        Connection db;
        ArrayList<String> dirList;
        block8: {
            dirList = new ArrayList<String>();
            db = this.openProjectDB();
            stmt = null;
            ResultSet rs = null;
            try {
                stmt = db.createStatement();
                rs = stmt.executeQuery(DerbyUtils.DIR_SELECT);
                while (rs.next()) {
                    Hashtable<CM_PROJECT, Object> rowData = DerbyUtils.getRowData(rs);
                    dirList.add(rowData.get((Object)CM_PROJECT.RELATIVE_FILE).toString());
                }
                Object var7_6 = null;
                if (null == rs) break block8;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (null != rs) {
                    rs.close();
                }
                if (null != stmt) {
                    stmt.close();
                }
                if (null != db) {
                    db.close();
                }
                throw throwable;
            }
            rs.close();
        }
        if (null != stmt) {
            stmt.close();
        }
        if (null != db) {
            db.close();
        }
        return dirList;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectRevision() {
        return this.projectRevision;
    }

    public boolean isNormal() {
        return this.projectType.equalsIgnoreCase(NORMAL_PROJECT);
    }

    public boolean isVariant() {
        return this.projectType.equalsIgnoreCase(VARIANT_PROJECT);
    }

    public boolean isBuild() {
        return this.projectType.equalsIgnoreCase(BUILD_PROJECT);
    }

    public String getConfigurationPath() {
        return this.fullConfigSyntax;
    }

    public Date getLastCheckpointDate() {
        return this.lastCheckpoint;
    }
}

