/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.model.AbstractBuild;
import hudson.scm.ChangeLogParser;
import hudson.scm.IntegrityChangeLogSet;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.digester3.Digester;
import org.xml.sax.SAXException;

public class IntegrityChangeLogParser
extends ChangeLogParser {
    private final String integrityURL;

    public IntegrityChangeLogParser(String url) {
        this.integrityURL = url;
    }

    public IntegrityChangeLogSet parse(AbstractBuild build, File changeLogFile) throws IOException, SAXException {
        ArrayList<IntegrityChangeLogSet.IntegrityChangeLog> changeSetList = new ArrayList<IntegrityChangeLogSet.IntegrityChangeLog>();
        Digester digester = new Digester();
        digester.push(changeSetList);
        digester.addObjectCreate("*/items/item", IntegrityChangeLogSet.IntegrityChangeLog.class);
        digester.addSetProperties("*/items/item");
        digester.addBeanPropertySetter("*/items/item/file");
        digester.addBeanPropertySetter("*/items/item/user");
        digester.addBeanPropertySetter("*/items/item/rev");
        digester.addBeanPropertySetter("*/items/item/date");
        digester.addBeanPropertySetter("*/items/item/annotation");
        digester.addBeanPropertySetter("*/items/item/differences");
        digester.addBeanPropertySetter("*/items/item/msg");
        digester.addSetNext("*/items/item", "add");
        digester.addObjectCreate("*/items/item/paths/path", IntegrityChangeLogSet.IntegrityChangeLogPath.class);
        digester.addSetProperties("*/items/item/paths/path");
        digester.addBeanPropertySetter("*/items/item/paths/path", "value");
        digester.addSetNext("*/items/item/paths/path", "addPath");
        try {
            digester.parse(changeLogFile);
        }
        catch (IOException e) {
            throw new IOException2("Failed to parse " + changeLogFile, (Throwable)e);
        }
        catch (SAXException e) {
            throw new IOException2("Failed to parse " + changeLogFile, (Throwable)e);
        }
        return new IntegrityChangeLogSet(build, changeSetList, this.integrityURL);
    }
}

