/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.mks.api.response.APIException;
import com.mks.api.util.Base64;
import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.remoting.VirtualChannel;
import hudson.scm.APISession;
import hudson.scm.CM_PROJECT;
import hudson.scm.ExceptionHandler;
import hudson.scm.IntegrityCMMember;
import hudson.scm.IntegritySCM;
import hudson.scm.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrityCheckoutTask
implements FilePath.FileCallable<Boolean> {
    private static final long serialVersionUID = 1240357991626897900L;
    private static final int CHECKOUT_TRESHOLD = 500;
    private final List<Hashtable<CM_PROJECT, Object>> projectMembersList;
    private final List<String> dirList;
    private final String lineTerminator;
    private final boolean restoreTimestamp;
    private final boolean cleanCopy;
    private final String alternateWorkspaceDir;
    private final boolean fetchChangedWorkspaceFiles;
    private final BuildListener listener;
    private String ipHostName;
    private String hostName;
    private int ipPort = 0;
    private int port;
    private boolean secure;
    private String userName;
    private String password;
    private Hashtable<String, String> checksumHash;
    private int addCount;
    private int updateCount;
    private int dropCount;
    private int fetchCount;

    public IntegrityCheckoutTask(List<Hashtable<CM_PROJECT, Object>> projectMembersList, List<String> dirList, String alternateWorkspaceDir, String lineTerminator, boolean restoreTimestamp, boolean cleanCopy, boolean fetchChangedWorkspaceFiles, BuildListener listener) {
        this.projectMembersList = projectMembersList;
        this.dirList = dirList;
        this.alternateWorkspaceDir = alternateWorkspaceDir;
        this.lineTerminator = lineTerminator;
        this.restoreTimestamp = restoreTimestamp;
        this.cleanCopy = cleanCopy;
        this.fetchChangedWorkspaceFiles = fetchChangedWorkspaceFiles;
        this.listener = listener;
        this.ipHostName = "";
        this.ipPort = 0;
        this.hostName = "";
        this.port = 7001;
        this.secure = false;
        this.userName = "";
        this.password = "";
        this.addCount = 0;
        this.updateCount = 0;
        this.dropCount = 0;
        this.fetchCount = 0;
        this.checksumHash = new Hashtable();
        Logger.debug("Integrity Checkout Task Created!");
    }

    public void initAPIVariables(String ipHostName, int ipPort, String hostName, int port, boolean secure, String userName, String password) {
        this.ipHostName = ipHostName;
        this.ipPort = ipPort;
        this.hostName = hostName;
        this.port = port;
        this.secure = secure;
        this.userName = userName;
        this.password = password;
    }

    public APISession createAPISession() {
        try {
            Logger.debug("Creating Integrity API Session...");
            return new APISession(this.ipHostName, this.ipPort, this.hostName, this.port, this.userName, Base64.decode((String)this.password), this.secure);
        }
        catch (APIException aex) {
            Logger.error("API Exception caught...");
            ExceptionHandler eh = new ExceptionHandler(aex);
            Logger.error(eh.getMessage());
            Logger.debug(eh.getCommand() + " returned exit code " + eh.getExitCode());
            Logger.fatal((Object)aex);
            return null;
        }
    }

    private void createFolderStructure(FilePath workspace) {
        Iterator<String> folders = this.dirList.iterator();
        while (folders.hasNext()) {
            File dir = new File(workspace + folders.next());
            if (dir.isDirectory()) continue;
            Logger.debug("Creating folder: " + dir.getAbsolutePath());
            dir.mkdirs();
        }
    }

    public Hashtable<String, String> getChecksumUpdates() {
        return this.checksumHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean invoke(File workspaceFile, VirtualChannel channel) throws IOException {
        File checkOutDir = null != this.alternateWorkspaceDir && this.alternateWorkspaceDir.length() > 0 ? new File(this.alternateWorkspaceDir) : workspaceFile;
        FilePath workspace = new FilePath(checkOutDir.isAbsolute() ? checkOutDir : new File(workspaceFile.getAbsolutePath() + IntegritySCM.FS + checkOutDir.getPath()));
        this.listener.getLogger().println("Checkout directory is " + workspace);
        APISession api = this.createAPISession();
        if (null == api) {
            this.listener.getLogger().println("Failed to establish an API connection to the Integrity Server!");
            return false;
        }
        try {
            int openFileHandles = 0;
            if (this.cleanCopy) {
                this.listener.getLogger().println("A clean copy is requested; deleting contents of " + workspace);
                Logger.debug("Deleting contents of workspace " + workspace);
                workspace.deleteContents();
                this.listener.getLogger().println("Populating clean workspace...");
            }
            this.createFolderStructure(workspace);
            Iterator<Hashtable<CM_PROJECT, Object>> it = this.projectMembersList.iterator();
            while (it.hasNext()) {
                String checksum;
                ++openFileHandles;
                Hashtable<CM_PROJECT, Object> memberInfo = it.next();
                int deltaFlag = null == memberInfo.get((Object)CM_PROJECT.DELTA) ? -1 : (int)Short.valueOf(memberInfo.get((Object)CM_PROJECT.DELTA).toString()).shortValue();
                File targetFile = new File(workspace + memberInfo.get((Object)CM_PROJECT.RELATIVE_FILE).toString());
                String memberName = memberInfo.get((Object)CM_PROJECT.NAME).toString();
                String memberID = memberInfo.get((Object)CM_PROJECT.MEMBER_ID).toString();
                String memberRev = memberInfo.get((Object)CM_PROJECT.REVISION).toString();
                String configPath = memberInfo.get((Object)CM_PROJECT.CONFIG_PATH).toString();
                String string = checksum = null == memberInfo.get((Object)CM_PROJECT.CHECKSUM) ? "" : memberInfo.get((Object)CM_PROJECT.CHECKSUM).toString();
                if (this.cleanCopy || deltaFlag == -1) {
                    Logger.debug("Attempting to checkout file: " + targetFile.getAbsolutePath() + " at revision " + memberRev);
                    IntegrityCMMember.checkout(api, configPath, memberID, memberRev, targetFile, this.restoreTimestamp, this.lineTerminator);
                    if (this.fetchChangedWorkspaceFiles) {
                        this.checksumHash.put(memberName, IntegrityCMMember.getMD5Checksum(targetFile));
                    }
                } else if (deltaFlag == 0 && this.fetchChangedWorkspaceFiles && checksum.length() > 0) {
                    if (!checksum.equals(IntegrityCMMember.getMD5Checksum(targetFile))) {
                        Logger.debug("Attempting to restore changed workspace file: " + targetFile.getAbsolutePath() + " to revision " + memberRev);
                        IntegrityCMMember.checkout(api, configPath, memberID, memberRev, targetFile, this.restoreTimestamp, this.lineTerminator);
                        ++this.fetchCount;
                    }
                } else if (deltaFlag == 1) {
                    Logger.debug("Attempting to get new file: " + targetFile.getAbsolutePath() + " at revision " + memberRev);
                    IntegrityCMMember.checkout(api, configPath, memberID, memberRev, targetFile, this.restoreTimestamp, this.lineTerminator);
                    ++this.addCount;
                    if (this.fetchChangedWorkspaceFiles) {
                        this.checksumHash.put(memberName, IntegrityCMMember.getMD5Checksum(targetFile));
                    }
                } else if (deltaFlag == 2) {
                    Logger.debug("Attempting to update file: " + targetFile.getAbsolutePath() + " to revision " + memberRev);
                    IntegrityCMMember.checkout(api, configPath, memberID, memberRev, targetFile, this.restoreTimestamp, this.lineTerminator);
                    ++this.updateCount;
                    if (this.fetchChangedWorkspaceFiles) {
                        this.checksumHash.put(memberName, IntegrityCMMember.getMD5Checksum(targetFile));
                    }
                } else if (deltaFlag == 3) {
                    Logger.debug("Attempting to drop file: " + targetFile.getAbsolutePath() + " was at revision " + memberRev);
                    ++this.dropCount;
                    if (targetFile.exists() && !targetFile.delete()) {
                        this.listener.getLogger().println("Failed to clean up workspace file " + targetFile.getAbsolutePath() + "!");
                        Boolean bl = false;
                        return bl;
                    }
                }
                if (openFileHandles % 500 != 0) continue;
                api.Terminate();
                api = this.createAPISession();
            }
            if (this.cleanCopy) {
                this.listener.getLogger().println("Successfully checked out " + this.projectMembersList.size() + " files!");
            } else {
                this.listener.getLogger().println("Successfully updated workspace with " + (this.addCount + this.updateCount) + " updates and cleaned up " + this.dropCount + " files!");
                if (this.fetchChangedWorkspaceFiles && this.fetchCount > 0) {
                    this.listener.getLogger().println("Additionally, a total of " + this.fetchCount + " files were restored to their original repository state!");
                }
            }
        }
        catch (APIException aex) {
            Logger.error("API Exception caught...");
            this.listener.getLogger().println("An API Exception was caught!");
            ExceptionHandler eh = new ExceptionHandler(aex);
            Logger.error(eh.getMessage());
            this.listener.getLogger().println(eh.getMessage());
            Logger.debug(eh.getCommand() + " returned exit code " + eh.getExitCode());
            this.listener.getLogger().println(eh.getCommand() + " returned exit code " + eh.getExitCode());
            Logger.fatal((Object)aex);
            Boolean bl = false;
            return bl;
        }
        catch (InterruptedException iex) {
            Logger.error("Interrupted Exception caught...");
            this.listener.getLogger().println("An Interrupted Exception was caught!");
            Logger.error(iex.getMessage());
            this.listener.getLogger().println(iex.getMessage());
            this.listener.getLogger().println("Failed to clean up workspace (" + workspace + ") contents!");
            Boolean bl = false;
            return bl;
        }
        finally {
            api.Terminate();
        }
        return true;
    }
}

