/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.mks.api.Command;
import com.mks.api.MultiValue;
import com.mks.api.Option;
import com.mks.api.response.APIException;
import com.mks.api.response.Response;
import com.mks.api.response.WorkItem;
import com.mks.api.util.Base64;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.scm.APISession;
import hudson.scm.CM_PROJECT;
import hudson.scm.ChangeLogParser;
import hudson.scm.DerbyUtils;
import hudson.scm.ExceptionHandler;
import hudson.scm.IntegrityCMProject;
import hudson.scm.IntegrityChangeLogParser;
import hudson.scm.IntegrityCheckoutTask;
import hudson.scm.IntegrityRepositoryBrowser;
import hudson.scm.IntegrityRevisionState;
import hudson.scm.Logger;
import hudson.scm.PollingResult;
import hudson.scm.RepositoryBrowsers;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegritySCM
extends SCM
implements Serializable {
    private static final long serialVersionUID = 7559894846609712683L;
    public static final String NL = System.getProperty("line.separator");
    public static final String FS = System.getProperty("file.separator");
    public static final int MIN_PORT_VALUE = 1;
    public static final int MAX_PORT_VALUE = 65535;
    public static final SimpleDateFormat SDF = new SimpleDateFormat("MMM dd, yyyy h:mm:ss a");
    private String ciServerURL;
    private String integrityURL;
    private IntegrityRepositoryBrowser browser;
    private String ipHostName;
    private String hostName;
    private int ipPort = 0;
    private int port;
    private boolean secure;
    private String configPath;
    private String userName;
    private String password;
    private boolean cleanCopy;
    private boolean skipAuthorInfo = false;
    private String lineTerminator = "native";
    private boolean restoreTimestamp = true;
    private boolean checkpointBeforeBuild = false;
    private String alternateWorkspace;
    private boolean fetchChangedWorkspaceFiles = false;
    private transient IntegrityCMProject siProject;

    @DataBoundConstructor
    public IntegritySCM(IntegrityRepositoryBrowser browser, String hostName, int port, boolean secure, String configPath, String userName, String password, String ipHostName, int ipPort, boolean cleanCopy, String lineTerminator, boolean restoreTimestamp, boolean skipAuthorInfo, boolean checkpointBeforeBuild, String alternateWorkspace, boolean fetchChangedWorkspaceFiles) {
        Logger.debug("IntegritySCM constructor has been invoked!");
        this.ciServerURL = Hudson.getInstance().getRootUrlFromRequest();
        this.browser = browser;
        this.ipHostName = ipHostName;
        this.hostName = hostName;
        this.ipPort = ipPort;
        this.port = port;
        this.secure = secure;
        this.configPath = configPath;
        this.userName = userName;
        this.password = Base64.encode((String)password);
        this.cleanCopy = cleanCopy;
        this.lineTerminator = lineTerminator;
        this.restoreTimestamp = restoreTimestamp;
        this.skipAuthorInfo = skipAuthorInfo;
        this.checkpointBeforeBuild = checkpointBeforeBuild;
        this.alternateWorkspace = alternateWorkspace;
        this.fetchChangedWorkspaceFiles = fetchChangedWorkspaceFiles;
        this.initIntegrityURL();
        Logger.debug("CI Server URL: " + this.ciServerURL);
        Logger.debug("URL: " + this.integrityURL);
        Logger.debug("IP Host: " + this.ipHostName);
        Logger.debug("Host: " + this.hostName);
        Logger.debug("IP Port: " + this.ipPort);
        Logger.debug("Port: " + this.port);
        Logger.debug("User: " + this.userName);
        Logger.debug("Password: " + DigestUtils.md5Hex((String)this.password));
        Logger.debug("Secure: " + this.secure);
        Logger.debug("Project: " + this.configPath);
        Logger.debug("Line Terminator: " + this.lineTerminator);
        Logger.debug("Restore Timestamp: " + this.restoreTimestamp);
        Logger.debug("Clean: " + this.cleanCopy);
        Logger.debug("Skip Author Info: " + this.skipAuthorInfo);
        Logger.debug("Checkpoint Before Build: " + this.checkpointBeforeBuild);
        Logger.debug("Alternate Workspace Directory: " + this.alternateWorkspace);
        Logger.debug("Fetch Changed Workspace Files: " + this.fetchChangedWorkspaceFiles);
    }

    @Exported
    public IntegrityRepositoryBrowser getBrowser() {
        return this.browser;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getipHostName() {
        return this.ipHostName;
    }

    public int getPort() {
        return this.port;
    }

    public int getipPort() {
        return this.ipPort;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return Base64.decode((String)this.password);
    }

    public boolean getCleanCopy() {
        return this.cleanCopy;
    }

    public String getLineTerminator() {
        return this.lineTerminator;
    }

    public boolean getRestoreTimestamp() {
        return this.restoreTimestamp;
    }

    public boolean getSkipAuthorInfo() {
        return this.skipAuthorInfo;
    }

    public boolean getCheckpointBeforeBuild() {
        return this.checkpointBeforeBuild;
    }

    public String getAlternateWorkspace() {
        return this.alternateWorkspace;
    }

    public boolean getFetchChangedWorkspaceFiles() {
        return this.fetchChangedWorkspaceFiles;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
        this.initIntegrityURL();
    }

    public void setipHostName(String ipHostName) {
        this.ipHostName = ipHostName;
    }

    public void setPort(int port) {
        this.port = port;
        this.initIntegrityURL();
    }

    public void setipPort(int ipPort) {
        this.ipPort = ipPort;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
        this.initIntegrityURL();
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = Base64.encode((String)password);
    }

    public void setCleanCopy(boolean cleanCopy) {
        this.cleanCopy = cleanCopy;
    }

    public void setLineTerminator(String lineTerminator) {
        this.lineTerminator = lineTerminator;
    }

    public void setRestoreTimestamp(boolean restoreTimestamp) {
        this.restoreTimestamp = restoreTimestamp;
    }

    public void setSkipAuthorInfo(boolean skipAuthorInfo) {
        this.skipAuthorInfo = skipAuthorInfo;
    }

    public void setCheckpointBeforeBuild(boolean checkpointBeforeBuild) {
        this.checkpointBeforeBuild = checkpointBeforeBuild;
    }

    public void setAlternateWorkspace(String alternateWorkspace) {
        this.alternateWorkspace = alternateWorkspace;
    }

    public void setFetchChangedWorkspaceFiles(boolean fetchChangedWorkspaceFiles) {
        this.fetchChangedWorkspaceFiles = fetchChangedWorkspaceFiles;
    }

    private void initIntegrityURL() {
        this.integrityURL = this.secure ? "https://" + this.hostName + ":" + String.valueOf(this.port) : "http://" + this.hostName + ":" + String.valueOf(this.port);
    }

    public APISession createAPISession() {
        try {
            Logger.debug("Creating Integrity API Session...");
            return new APISession(this.ipHostName, this.ipPort, this.hostName, this.port, this.userName, Base64.decode((String)this.password), this.secure);
        }
        catch (APIException aex) {
            Logger.error("API Exception caught...");
            ExceptionHandler eh = new ExceptionHandler(aex);
            Logger.error(eh.getMessage());
            Logger.debug(eh.getCommand() + " returned exit code " + eh.getExitCode());
            aex.printStackTrace();
            return null;
        }
    }

    public IntegrityCMProject getIntegrityProject() {
        return this.siProject;
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        Logger.debug("buildEnvVars() invoked...!");
        env.put("MKSSI_PROJECT", this.configPath);
        env.put("MKSSI_HOST", this.hostName);
        env.put("MKSSI_PORT", String.valueOf(this.port));
        env.put("MKSSI_USER", this.userName);
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        Logger.debug("calcRevisionsFromBuild() invoked...!");
        File projectDB = this.getIntegrityCMProjectDB(build);
        return new IntegrityRevisionState(projectDB);
    }

    private Response initializeCMProject(APISession api, File projectDB) throws APIException {
        Command siProjectInfoCmd = new Command("si", "projectinfo");
        siProjectInfoCmd.addOption(new Option("project", this.configPath));
        Logger.debug("Preparing to execute si projectinfo for " + this.configPath);
        Response infoRes = api.runCommand(siProjectInfoCmd);
        Logger.debug(infoRes.getCommandString() + " returned " + infoRes.getExitCode());
        this.siProject = new IntegrityCMProject(infoRes.getWorkItems().next(), projectDB);
        this.siProject.setLineTerminator(this.lineTerminator);
        this.siProject.setRestoreTimestamp(this.restoreTimestamp);
        this.siProject.setSkipAuthorInfo(this.skipAuthorInfo);
        return infoRes;
    }

    private Response initializeCMProjectMembers(APISession api) throws APIException, SQLException {
        Command siViewProjectCmd = new Command("si", "viewproject");
        siViewProjectCmd.addOption(new Option("recurse"));
        siViewProjectCmd.addOption(new Option("project", this.siProject.getConfigurationPath()));
        MultiValue mvFields = new MultiValue(",");
        mvFields.add("name");
        mvFields.add("context");
        mvFields.add("cpid");
        mvFields.add("memberrev");
        mvFields.add("membertimestamp");
        mvFields.add("memberdescription");
        siViewProjectCmd.addOption(new Option("fields", mvFields));
        Logger.debug("Preparing to execute si viewproject for " + this.siProject.getConfigurationPath());
        Response viewRes = api.runCommandWithInterim(siViewProjectCmd);
        this.siProject.parseProject(viewRes.getWorkItems());
        return viewRes;
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    private File getIntegrityCMProjectDB(AbstractBuild<?, ?> build) {
        File projectDB = null;
        if (null != build && !(projectDB = new File(build.getRootDir(), "IntegritySCM")).isDirectory()) {
            Logger.debug("Integrity SCM Project DB not found for build " + build.getNumber() + "!");
        }
        return projectDB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkout(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changeLogFile) throws IOException, InterruptedException {
        block17: {
            Logger.debug("Start execution of checkout() routine...!");
            listener.getLogger().println("Change Log: " + this.ciServerURL + build.getUrl() + "changes");
            listener.getLogger().println("Build Log: " + this.ciServerURL + build.getUrl() + "console");
            APISession api = this.createAPISession();
            if (null == api) {
                listener.getLogger().println("Failed to establish an API connection to the Integrity Server!");
                return false;
            }
            PrintWriter writer = new PrintWriter(new FileWriter(changeLogFile));
            try {
                File prevProjectDB;
                listener.getLogger().println("Preparing to execute si projectinfo for " + this.configPath);
                this.initializeCMProject(api, build.getRootDir());
                if (this.checkpointBeforeBuild) {
                    if (!this.siProject.isBuild()) {
                        listener.getLogger().println("Preparing to execute pre-build si checkpoint for " + this.siProject.getConfigurationPath());
                        Response res = this.siProject.checkpoint(api, "");
                        Logger.debug(res.getCommandString() + " returned " + res.getExitCode());
                        WorkItem wi = res.getWorkItem(this.siProject.getConfigurationPath());
                        String chkpt = wi.getResult().getField("resultant").getItem().getId();
                        listener.getLogger().println("Successfully executed pre-build checkpoint for project " + this.siProject.getConfigurationPath() + ", new revision is " + chkpt);
                        Command siProjectInfoCmd = new Command("si", "projectinfo");
                        siProjectInfoCmd.addOption(new Option("project", this.siProject.getProjectName()));
                        siProjectInfoCmd.addOption(new Option("projectRevision", chkpt));
                        Response infoRes = api.runCommand(siProjectInfoCmd);
                        this.siProject.initializeProject(infoRes.getWorkItems().next());
                    } else {
                        listener.getLogger().println("Cannot perform a pre-build checkpoint for build project configuration!");
                    }
                }
                listener.getLogger().println("Preparing to execute si viewproject for " + this.siProject.getConfigurationPath());
                this.initializeCMProjectMembers(api);
                AbstractBuild previousBuild = (AbstractBuild)build.getPreviousBuild();
                for (AbstractBuild b = (AbstractBuild)build.getPreviousBuild(); null != b; b = (AbstractBuild)b.getPreviousBuild()) {
                    File prevProjectDB2 = new File(build.getRootDir(), "IntegritySCM");
                    if (!prevProjectDB2.isDirectory()) continue;
                    Logger.debug("Found previous project state in build " + b.getNumber());
                    previousBuild = b;
                    break;
                }
                if (null != (prevProjectDB = this.getIntegrityCMProjectDB(previousBuild)) && prevProjectDB.isDirectory()) {
                    this.siProject.compareBaseline(prevProjectDB.getParentFile(), api);
                } else {
                    Logger.debug("Cannot construct project state for any of the pevious builds!");
                    if (!this.skipAuthorInfo) {
                        this.siProject.primeAuthorInformation(api);
                    }
                }
                List<Hashtable<CM_PROJECT, Object>> projectMembersList = this.siProject.viewProject();
                List<String> dirList = this.siProject.getDirList();
                IntegrityCheckoutTask coTask = null;
                coTask = null == prevProjectDB ? new IntegrityCheckoutTask(projectMembersList, dirList, this.alternateWorkspace, this.lineTerminator, this.restoreTimestamp, true, this.fetchChangedWorkspaceFiles, listener) : new IntegrityCheckoutTask(projectMembersList, dirList, this.alternateWorkspace, this.lineTerminator, this.restoreTimestamp, this.cleanCopy, this.fetchChangedWorkspaceFiles, listener);
                coTask.initAPIVariables(this.ipHostName, this.ipPort, this.hostName, this.port, this.secure, this.userName, this.password);
                if (((Boolean)workspace.act((FilePath.FileCallable)coTask)).booleanValue()) {
                    listener.getLogger().println("Saving current Integrity Project configuration...");
                    if (this.fetchChangedWorkspaceFiles) {
                        this.siProject.updateChecksum(coTask.getChecksumUpdates());
                    }
                    listener.getLogger().println("Writing build change log...");
                    writer.println(this.siProject.getChangeLog(String.valueOf(build.getNumber()), projectMembersList));
                    listener.getLogger().println("Change log successfully generated: " + changeLogFile.getAbsolutePath());
                    break block17;
                }
                boolean bl = false;
                return bl;
            }
            catch (APIException aex) {
                Logger.error("API Exception caught...");
                listener.getLogger().println("An API Exception was caught!");
                ExceptionHandler eh = new ExceptionHandler(aex);
                Logger.error(eh.getMessage());
                listener.getLogger().println(eh.getMessage());
                Logger.debug(eh.getCommand() + " returned exit code " + eh.getExitCode());
                listener.getLogger().println(eh.getCommand() + " returned exit code " + eh.getExitCode());
                Logger.fatal((Object)aex);
                boolean bl = false;
                return bl;
            }
            catch (SQLException sqlex) {
                Logger.error("SQL Exception caught...");
                listener.getLogger().println("A SQL Exception was caught!");
                listener.getLogger().println(sqlex.getMessage());
                Logger.fatal(sqlex);
                boolean bl = false;
                return bl;
            }
            finally {
                writer.close();
                this.siProject.closeProjectDB();
                api.Terminate();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState _baseline) throws IOException, InterruptedException {
        Logger.debug("compareRemoteRevisionWith() invoked...!");
        if (_baseline instanceof IntegrityRevisionState) {
            IntegrityRevisionState baseline = (IntegrityRevisionState)_baseline;
            AbstractBuild lastBuild = (AbstractBuild)project.getLastBuild();
            if (null == lastBuild) {
                Logger.debug("No prior successful builds found!  Advice to build now!");
                return PollingResult.BUILD_NOW;
            }
            baseline = (IntegrityRevisionState)this.calcRevisionsFromBuild(lastBuild, launcher, listener);
            if (null != baseline && null != baseline.getProjectDB()) {
                File projectDB = baseline.getProjectDB().getParentFile();
                APISession api = this.createAPISession();
                if (null != api) {
                    try {
                        listener.getLogger().println("Preparing to execute si projectinfo for " + this.configPath);
                        this.initializeCMProject(api, new File(lastBuild.getRootDir(), "PollingResult"));
                        listener.getLogger().println("Preparing to execute si viewproject for " + this.configPath);
                        this.initializeCMProjectMembers(api);
                        int changeCount = this.siProject.compareBaseline(projectDB, api);
                        if (changeCount > 0) {
                            listener.getLogger().println("Project contains changes a total of " + changeCount + " changes!");
                            PollingResult pollingResult = PollingResult.SIGNIFICANT;
                            return pollingResult;
                        }
                        listener.getLogger().println("No new changes detected in project!");
                        PollingResult pollingResult = PollingResult.NO_CHANGES;
                        return pollingResult;
                    }
                    catch (APIException aex) {
                        Logger.error("API Exception caught...");
                        listener.getLogger().println("An API Exception was caught!");
                        ExceptionHandler eh = new ExceptionHandler(aex);
                        Logger.error(eh.getMessage());
                        listener.getLogger().println(eh.getMessage());
                        Logger.debug(eh.getCommand() + " returned exit code " + eh.getExitCode());
                        listener.getLogger().println(eh.getCommand() + " returned exit code " + eh.getExitCode());
                        aex.printStackTrace();
                        PollingResult pollingResult = PollingResult.NO_CHANGES;
                        return pollingResult;
                    }
                    catch (SQLException sqlex) {
                        Logger.error("SQL Exception caught...");
                        listener.getLogger().println("A SQL Exception was caught!");
                        listener.getLogger().println(sqlex.getMessage());
                        Logger.fatal(sqlex);
                        PollingResult pollingResult = PollingResult.NO_CHANGES;
                        return pollingResult;
                    }
                    finally {
                        api.Terminate();
                        DerbyUtils.shutdownDB(projectDB);
                        this.siProject.closeProjectDB();
                    }
                }
                listener.getLogger().println("Failed to establish an API connection to the Integrity Server!");
                return PollingResult.NO_CHANGES;
            }
            Logger.debug("No prior Integrity Project state can be found!  Advice to build now!");
            return PollingResult.BUILD_NOW;
        }
        Logger.error("This method was called with the wrong SCMRevisionState class!");
        return PollingResult.NO_CHANGES;
    }

    public ChangeLogParser createChangeLogParser() {
        Logger.debug("createChangeLogParser() invoked...!");
        return new IntegrityChangeLogParser(this.integrityURL);
    }

    public SCMDescriptor<IntegritySCM> getDescriptor() {
        Logger.debug("IntegritySCM.getDescriptor() invoked...!");
        return DescriptorImpl.INTEGRITY_DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends SCMDescriptor<IntegritySCM> {
        @Extension
        public static final DescriptorImpl INTEGRITY_DESCRIPTOR = new DescriptorImpl();
        private String defaultHostName = Util.getHostName();
        private String defaultIPHostName = "";
        private int defaultPort = 7001;
        private int defaultIPPort = 0;
        private boolean defaultSecure = false;
        private String defaultUserName = "";
        private String defaultPassword = "";

        protected DescriptorImpl() {
            super(IntegritySCM.class, IntegrityRepositoryBrowser.class);
            this.load();
            DerbyUtils.setDerbySystemDir(Hudson.getInstance().getRootDir());
            DerbyUtils.loadDerbyDriver();
            Logger.debug("IntegritySCM DescriptorImpl() constructed!");
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            IntegritySCM scm = (IntegritySCM)super.newInstance(req, formData);
            scm.browser = (IntegrityRepositoryBrowser)RepositoryBrowsers.createInstance(IntegrityRepositoryBrowser.class, (StaplerRequest)req, (JSONObject)formData, (String)"browser");
            return scm;
        }

        public String getDisplayName() {
            return "Integrity - CM";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            Logger.debug("Request to configure IntegritySCM (SCMDescriptor) invoked...");
            Logger.debug("mks.defaultHostName = " + req.getParameter("mks.defaultHostName"));
            this.defaultHostName = Util.fixEmptyAndTrim((String)req.getParameter("mks.defaultHostName"));
            Logger.debug("defaultHostName = " + this.defaultHostName);
            Logger.debug("mks.defaultIPHostName = " + req.getParameter("mks.defaultIPHostName"));
            this.defaultIPHostName = Util.fixEmptyAndTrim((String)req.getParameter("mks.defaultIPHostName"));
            Logger.debug("defaultIPHostName = " + this.defaultIPHostName);
            Logger.debug("mks.defaultPort = " + req.getParameter("mks.defaultPort"));
            this.defaultPort = Integer.parseInt(Util.fixNull((String)req.getParameter("mks.defaultPort")));
            Logger.debug("defaultPort = " + this.defaultPort);
            Logger.debug("mks.defaultIPPort = " + req.getParameter("mks.defaultIPPort"));
            this.defaultIPPort = Integer.parseInt(Util.fixNull((String)req.getParameter("mks.defaultIPPort")));
            Logger.debug("defaultIPPort = " + this.defaultIPPort);
            Logger.debug("mks.defaultSecure = " + req.getParameter("mks.defaultSecure"));
            this.defaultSecure = "on".equalsIgnoreCase(Util.fixEmptyAndTrim((String)req.getParameter("mks.defaultSecure")));
            Logger.debug("defaultSecure = " + this.defaultSecure);
            Logger.debug("mks.defaultUserName = " + req.getParameter("mks.defaultUserName"));
            this.defaultUserName = Util.fixEmptyAndTrim((String)req.getParameter("mks.defaultUserName"));
            Logger.debug("defaultUserName = " + this.defaultUserName);
            this.defaultPassword = Base64.encode((String)Util.fixEmptyAndTrim((String)req.getParameter("mks.defaultPassword")));
            Logger.debug("defaultPassword = " + DigestUtils.md5Hex((String)this.defaultPassword));
            this.save();
            return true;
        }

        public String getDefaultHostName() {
            return this.defaultHostName;
        }

        public String getDefaultIPHostName() {
            return this.defaultIPHostName;
        }

        public int getDefaultPort() {
            return this.defaultPort;
        }

        public int getDefaultIPPort() {
            return this.defaultIPPort;
        }

        public boolean getDefaultSecure() {
            return this.defaultSecure;
        }

        public String getDefaultUserName() {
            return this.defaultUserName;
        }

        public String getDefaultPassword() {
            return Base64.decode((String)this.defaultPassword);
        }

        public void setDefaultHostName(String defaultHostName) {
            this.defaultHostName = defaultHostName;
        }

        public void setDefaultIPHostName(String defaultIPHostName) {
            this.defaultIPHostName = defaultIPHostName;
        }

        public void setDefaultPort(int defaultPort) {
            this.defaultPort = defaultPort;
        }

        public void setDefaultIPPort(int defaultIPPort) {
            this.defaultIPPort = defaultIPPort;
        }

        public void setDefaultSecure(boolean defaultSecure) {
            this.defaultSecure = defaultSecure;
        }

        public void setDefaultUserName(String defaultUserName) {
            this.defaultUserName = defaultUserName;
        }

        public void setDefaultPassword(String defaultPassword) {
            this.defaultPassword = Base64.encode((String)defaultPassword);
        }

        public FormValidation doValidPortCheck(@QueryParameter String value) {
            try {
                int intValue = Integer.parseInt(value);
                if (intValue + 1 < 1 || intValue > 65535) {
                    return FormValidation.error((String)"Value must be between 1 and 65535!");
                }
            }
            catch (NumberFormatException nfe) {
                return FormValidation.error((String)"Value must be numeric!");
            }
            return FormValidation.ok();
        }
    }
}

