/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.mks.api.response.APIException;
import com.mks.api.response.Field;
import com.mks.api.response.WorkItem;
import com.mks.api.response.WorkItemIterator;
import hudson.scm.APISession;
import hudson.scm.IntegrityCMMember;
import hudson.scm.IntegritySCM;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrityCMProject
implements Serializable {
    private static final long serialVersionUID = 6452315129657215760L;
    public static final String NORMAL_PROJECT = "Normal";
    public static final String VARIANT_PROJECT = "Variant";
    public static final String BUILD_PROJECT = "Build";
    private String projectName;
    private String projectType;
    private String fullConfigSyntax;
    private Date lastCheckpoint;
    private String lineTerminator = "native";
    private boolean restoreTimestamp = true;
    private List<IntegrityCMMember> memberList = new ArrayList();
    private List<IntegrityCMMember> newMemberList = new ArrayList();
    private List<IntegrityCMMember> updatedMemberList = new ArrayList();
    private List<IntegrityCMMember> deletedMemberList = new ArrayList();
    private StringBuffer changeLog = new StringBuffer();
    public static final Comparator<IntegrityCMMember> FILES_ORDER = new /* Unavailable Anonymous Inner Class!! */;
    private static final Log logger = LogFactory.getLog(IntegrityCMProject.class);

    public IntegrityCMProject(WorkItem wi) {
        try {
            Field pjNameFld = wi.getField("projectName");
            Field pjTypeFld = wi.getField("projectType");
            Field pjCfgPathFld = wi.getField("fullConfigSyntax");
            Field pjChkptFld = wi.getField("lastCheckpoint");
            if (null != pjNameFld && null != pjNameFld.getValueAsString()) {
                this.projectName = pjNameFld.getValueAsString();
            } else {
                logger.warn((Object)"Project info did not provide a value for the 'projectName' field!");
                this.projectName = "";
            }
            if (null != pjTypeFld && null != pjTypeFld.getValueAsString()) {
                this.projectType = pjTypeFld.getValueAsString();
            } else {
                logger.warn((Object)"Project info did not provide a value for the 'projectType' field!");
                this.projectType = "";
            }
            if (null != pjCfgPathFld && null != pjCfgPathFld.getValueAsString()) {
                this.fullConfigSyntax = pjCfgPathFld.getValueAsString();
            } else {
                logger.error((Object)"Project info did not provide a value for the 'fullConfigSyntax' field!");
                this.fullConfigSyntax = "";
            }
            if (null != pjChkptFld && null != pjChkptFld.getDateTime()) {
                this.lastCheckpoint = pjChkptFld.getDateTime();
            } else {
                logger.warn((Object)"Project info did not provide a value for the 'lastCheckpoint' field!");
                this.lastCheckpoint = Calendar.getInstance().getTime();
            }
        }
        catch (NoSuchElementException nsee) {
            logger.error((Object)("Project info did not provide a value for field " + nsee.getMessage()));
        }
    }

    public void setLineTerminator(String lineTerminator) {
        this.lineTerminator = lineTerminator;
    }

    public void setRestoreTimestamp(boolean restoreTimestamp) {
        this.restoreTimestamp = restoreTimestamp;
    }

    public void parseProject(WorkItemIterator wit) throws APIException {
        this.memberList = new ArrayList();
        Hashtable<String, String> pjConfigHash = new Hashtable<String, String>();
        pjConfigHash.put(this.projectName, this.fullConfigSyntax);
        String projectRoot = this.projectName.substring(0, this.projectName.lastIndexOf(47));
        while (wit.hasNext()) {
            WorkItem wi = wit.next();
            if (wi.getModelType().equals("si.Subproject")) {
                pjConfigHash.put(wi.getField("name").getValueAsString(), wi.getId());
                continue;
            }
            if (wi.getModelType().equals("si.Member")) {
                String parentProject = wi.getField("parent").getValueAsString();
                IntegrityCMMember iCMMember = new IntegrityCMMember(wi, (String)pjConfigHash.get(parentProject), projectRoot);
                iCMMember.setLineTerminator(this.lineTerminator);
                iCMMember.setRestoreTimestamp(this.restoreTimestamp);
                this.memberList.add(iCMMember);
                continue;
            }
            logger.warn((Object)("View project output contains an invalid model type: " + wi.getModelType()));
        }
        Collections.sort(this.memberList, FILES_ORDER);
        logger.info((Object)("Parsing project " + this.fullConfigSyntax + " complete!"));
    }

    public void compareBaseline(IntegrityCMProject baselineProject) {
        List oldMemberList = baselineProject.getProjectMembers();
        Hashtable<String, IntegrityCMMember> oldMemberHash = new Hashtable<String, IntegrityCMMember>();
        for (IntegrityCMMember iMember : oldMemberList) {
            oldMemberHash.put(iMember.getMemberName(), iMember);
        }
        for (IntegrityCMMember iMember : this.memberList) {
            IntegrityCMMember oldMember = (IntegrityCMMember)oldMemberHash.get(iMember.getMemberName());
            if (null != oldMember) {
                if (iMember.getTimestamp().after(oldMember.getTimestamp()) || iMember.getTimestamp().before(oldMember.getTimestamp())) {
                    iMember.setPriorRevision(oldMember.getRevision());
                    this.updatedMemberList.add(iMember);
                }
                oldMemberHash.remove(oldMember.getMemberName());
                continue;
            }
            this.newMemberList.add(iMember);
        }
        Enumeration deletedMembers = oldMemberHash.elements();
        while (deletedMembers.hasMoreElements()) {
            this.deletedMemberList.add(deletedMembers.nextElement());
        }
    }

    public String getChangeLog(String version, APISession api) throws APIException {
        this.changeLog = new StringBuffer();
        this.writeChangeLog("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        if (this.hasProjectChanged()) {
            this.writeChangeLog("<changelog>");
            this.writeChangeLog(String.format("\t<items version=\"%s\">", version));
            Iterator it = this.newMemberList.iterator();
            while (it.hasNext()) {
                this.writeChangeLog(String.format("\t\t<item action=\"%s\">", "add"));
                this.writeChangeLog((IntegrityCMMember)it.next(), api);
            }
            it = this.updatedMemberList.iterator();
            while (it.hasNext()) {
                this.writeChangeLog(String.format("\t\t<item action=\"%s\">", "update"));
                this.writeChangeLog((IntegrityCMMember)it.next(), api);
            }
            it = this.deletedMemberList.iterator();
            while (it.hasNext()) {
                this.writeChangeLog(String.format("\t\t<item action=\"%s\">", "delete"));
                this.writeChangeLog((IntegrityCMMember)it.next(), api);
            }
            this.writeChangeLog("\t</items>");
            this.writeChangeLog("</changelog>");
        } else {
            this.writeChangeLog("<changelog/>");
        }
        return this.changeLog.toString();
    }

    private void writeChangeLog(IntegrityCMMember iMember, APISession api) throws APIException {
        this.writeChangeLog(String.format("\t\t\t<file>%s</file>", iMember.getMemberName()));
        this.writeChangeLog(String.format("\t\t\t<user>%s</user>", iMember.getAuthor(api)));
        this.writeChangeLog(String.format("\t\t\t<revision>%s</revision>", iMember.getRevision()));
        this.writeChangeLog(String.format("\t\t\t<date>%s</date>", IntegritySCM.SDF.format(iMember.getTimestamp())));
        try {
            this.writeChangeLog(String.format("\t\t\t<annotation><![CDATA[%s]]></annotation>", iMember.getAnnotatedLink()));
            this.writeChangeLog(String.format("\t\t\t<differences><![CDATA[%s]]></differences>", iMember.getDifferencesLink()));
        }
        catch (UnsupportedEncodingException uee) {
            logger.warn((Object)"Caught Unsupported Encoding Exception while generating MKS Integrity Source links!");
            logger.warn((Object)uee.getMessage());
        }
        this.writeChangeLog(String.format("\t\t\t<msg><![CDATA[%s]]></msg>", iMember.getDescription()));
        this.writeChangeLog("\t\t</item>");
    }

    private void writeChangeLog(String line) {
        this.changeLog.append(line + IntegritySCM.NL);
    }

    public boolean hasProjectChanged() {
        return this.getChangeCount() > 0;
    }

    public int getChangeCount() {
        return this.newMemberList.size() + this.updatedMemberList.size() + this.deletedMemberList.size();
    }

    public List<IntegrityCMMember> getProjectMembers() {
        return this.memberList;
    }

    public List<IntegrityCMMember> getAddedMembers() {
        return this.newMemberList;
    }

    public List<IntegrityCMMember> getUpdatedMembers() {
        return this.updatedMemberList;
    }

    public List<IntegrityCMMember> getDroppedMembers() {
        return this.deletedMemberList;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public boolean isNormal() {
        return this.projectType.equalsIgnoreCase(NORMAL_PROJECT);
    }

    public boolean isVariant() {
        return this.projectType.equalsIgnoreCase(VARIANT_PROJECT);
    }

    public boolean isBuild() {
        return this.projectType.equalsIgnoreCase(BUILD_PROJECT);
    }

    public String getConfigurationPath() {
        return this.fullConfigSyntax;
    }

    public Date getLastCheckpointDate() {
        return this.lastCheckpoint;
    }
}

