/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.browsers;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.scm.IntegrityChangeLogSet;
import hudson.scm.IntegrityRepositoryBrowser;
import hudson.scm.RepositoryBrowser;
import hudson.scm.browsers.IntegrityWebUI;
import java.io.IOException;
import java.net.URL;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrityWebUI
extends IntegrityRepositoryBrowser {
    public final String url;
    @Extension
    public static final IntegrityWebUIDescriptorImpl WEBUI_DESCRIPTOR = new IntegrityWebUIDescriptorImpl();
    private static final long serialVersionUID = 6861438752583904309L;

    @DataBoundConstructor
    public IntegrityWebUI(String url) {
        this.url = url;
    }

    public Descriptor<RepositoryBrowser<?>> getDescriptor() {
        return WEBUI_DESCRIPTOR;
    }

    public URL getDiffLink(IntegrityChangeLogSet.IntegrityChangeLog logEntry) throws IOException {
        URL context = null;
        if (null != this.url && this.url.length() > 0) {
            context = this.url.endsWith("/") ? new URL(this.url + "si/") : new URL(this.url + "/si/");
            return new URL(context, logEntry.getDifferences());
        }
        context = new URL(logEntry.getParent().getIntegrityURL() + "/si/");
        return new URL(context, logEntry.getDifferences());
    }

    public URL getChangeSetLink(IntegrityChangeLogSet.IntegrityChangeLog logEntry) throws IOException {
        URL context = null;
        if (null != this.url && this.url.length() > 0) {
            context = this.url.endsWith("/") ? new URL(this.url + "si/") : new URL(this.url + "/si/");
            return new URL(context, logEntry.getAnnotation());
        }
        context = new URL(logEntry.getParent().getIntegrityURL() + "/si/");
        return new URL(context, logEntry.getAnnotation());
    }
}

