/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.mks.api.Command;
import com.mks.api.FileOption;
import com.mks.api.Option;
import com.mks.api.response.APIException;
import com.mks.api.response.Response;
import com.mks.api.response.WorkItem;
import hudson.scm.APISession;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IntegrityCMMember
implements Serializable {
    private static final long serialVersionUID = 880318565064448175L;
    private static final String ENCODING = "UTF-8";
    private String memberID;
    private String memberName;
    private Date memberTimestamp;
    private String memberDescription;
    private String author;
    private String projectConfigPath;
    private String memberRev;
    private String priorRev;
    private File targetFile;
    private String relativeFile;
    private String lineTerminator;
    private String overwriteExisting;
    private String restoreTimestamp;
    private final Log logger = LogFactory.getLog(this.getClass());

    public IntegrityCMMember(WorkItem wi, String configPath, String projectRoot, APISession api) throws APIException {
        this.projectConfigPath = configPath;
        this.memberID = wi.getId();
        this.memberName = wi.getField("name").getValueAsString();
        this.memberRev = wi.getField("memberrev").getItem().getId();
        this.priorRev = "";
        this.memberTimestamp = wi.getField("membertimestamp").getDateTime();
        this.memberDescription = null != wi.getField("memberdescription") && null != wi.getField("memberdescription").getValueAsString() ? wi.getField("memberdescription").getValueAsString() : new String("");
        this.lineTerminator = "native";
        this.overwriteExisting = "overwriteExisting";
        this.restoreTimestamp = "restoreTimestamp";
        this.relativeFile = this.memberName.substring(projectRoot.length());
        this.targetFile = new File(this.relativeFile);
        this.author = this.getAuthor(api);
    }

    public void setWorkspaceDir(String workspaceDir) {
        this.targetFile = new File(workspaceDir + this.relativeFile);
    }

    public String getTargetFilePath() {
        return this.targetFile.getAbsolutePath();
    }

    public String getRevision() {
        return this.memberRev;
    }

    public Date getTimestamp() {
        return this.memberTimestamp;
    }

    public String getDescription() {
        return this.memberDescription;
    }

    public String getAuthor() {
        if (null != this.author) {
            return this.author;
        }
        return "unknown";
    }

    public String getMemberName() {
        return this.memberName;
    }

    public String getName() {
        if (this.memberID.indexOf(47) > 0) {
            return this.memberID.substring(this.memberID.lastIndexOf(47) + 1);
        }
        if (this.memberID.indexOf(92) > 0) {
            return this.memberID.substring(this.memberID.lastIndexOf(92) + 1);
        }
        return this.memberID;
    }

    public String getAnnotatedLink() throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append("annotate?projectName=");
        sb.append(URLEncoder.encode(this.projectConfigPath, ENCODING));
        sb.append("&revision=");
        sb.append(this.memberRev);
        sb.append("&selection=");
        sb.append(URLEncoder.encode(this.memberID, ENCODING));
        return sb.toString();
    }

    public String getDifferencesLink() throws UnsupportedEncodingException {
        if (null != this.priorRev && this.priorRev.length() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("diff?projectName=");
            sb.append(URLEncoder.encode(this.projectConfigPath, ENCODING));
            sb.append("&oldRevision=");
            sb.append(this.priorRev);
            sb.append("&newRevision=");
            sb.append(this.memberRev);
            sb.append("&selection=");
            sb.append(URLEncoder.encode(this.memberID, ENCODING));
            return sb.toString();
        }
        return new String("");
    }

    public void setPriorRevision(String revision) {
        this.priorRev = revision;
    }

    public void setLineTerminator(String lineTerminator) {
        this.lineTerminator = lineTerminator;
    }

    public void setOverwriteExisting(String overwriteExisting) {
        this.overwriteExisting = overwriteExisting;
    }

    public void setRestoreTimestamp(boolean restoreTime) {
        this.restoreTimestamp = restoreTime ? "restoreTimestamp" : "norestoreTimestamp";
    }

    public boolean checkout(APISession api) throws APIException {
        if (!this.targetFile.getParentFile().isDirectory()) {
            this.targetFile.getParentFile().mkdirs();
        }
        Command coCMD = new Command("si", "projectco");
        coCMD.addOption(new Option(this.overwriteExisting));
        coCMD.addOption(new Option("nolock"));
        coCMD.addOption(new Option("project", this.projectConfigPath));
        coCMD.addOption((Option)new FileOption("targetFile", this.targetFile));
        coCMD.addOption(new Option(this.restoreTimestamp));
        coCMD.addOption(new Option("lineTerminator", this.lineTerminator));
        coCMD.addOption(new Option("revision", this.memberRev));
        coCMD.addSelection(this.memberID);
        Response res = api.runCommand(coCMD);
        this.logger.info((Object)("Command: " + res.getCommandString() + " completed with exit code " + res.getExitCode()));
        return res.getExitCode() == 0;
    }

    private String getAuthor(APISession api) throws APIException {
        Command revInfoCMD = new Command("si", "revisioninfo");
        revInfoCMD.addOption(new Option("project", this.projectConfigPath));
        revInfoCMD.addOption(new Option("revision", this.memberRev));
        revInfoCMD.addSelection(this.memberID);
        Response res = api.runCommand(revInfoCMD);
        this.logger.info((Object)("Command: " + res.getCommandString() + " completed with exit code " + res.getExitCode()));
        if (res.getExitCode() == 0) {
            return res.getWorkItem(this.memberID).getField("author").getValueAsString();
        }
        return "unknown";
    }

    public boolean equals(Object o) {
        if (o instanceof IntegrityCMMember && null != o) {
            return ((IntegrityCMMember)o).getMemberName().equals(this.getMemberName());
        }
        return false;
    }
}

